<?php
/*
 +-------------------------------------------------------------------------+
 | Copyright (C) 2004-2011 The Cacti Group                                 |
 |                                                                         |
 | This program is free software; you can redistribute it and/or           |
 | modify it under the terms of the GNU General Public License             |
 | as published by the Free Software Foundation; either version 2          |
 | of the License, or (at your option) any later version.                  |
 |                                                                         |
 | This program is distributed in the hope that it will be useful,         |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of          |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           |
 | GNU General Public License for more details.                            |
 +-------------------------------------------------------------------------+
 | Cacti: The Complete RRDTool-based Graphing Solution                     |
 +-------------------------------------------------------------------------+
 | This code is designed, written, and maintained by the Cacti Group. See  |
 | about.php and/or the AUTHORS file for specific developer information.   |
 +-------------------------------------------------------------------------+
 | http://www.cacti.net/                                                   |
 +-------------------------------------------------------------------------+
*/

if (!defined("VALID_HOST_FIELDS")) {
	define("VALID_HOST_FIELDS", "(hostname|host_id|snmp_community|snmp_username|snmp_password|snmp_auth_protocol|snmp_priv_passphrase|snmp_priv_protocol|snmp_context|snmp_version|snmp_port|snmp_timeout)");
}

/* file: cdef.php, action: edit */
$fields_cdef_edit = array(
	"name" => array(
		"method" => "textbox",
		"friendly_name" => "名前",
		"description" => "CDEFの名前を指定します。",
		"value" => "|arg1:name|",
		"max_length" => "255",
		"size" => "60"
		),
	"id" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:id|"
		),
	"save_component_cdef" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

/* file: color.php, action: edit */
$fields_color_edit = array(
	"hex" => array(
		"method" => "textbox",
		"friendly_name" => "16進数",
		"description" => "色を16進数表記で指定します（設定値: 000000-FFFFFF）",
		"value" => "|arg1:hex|",
		"max_length" => "6",
		),
	"id" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:id|"
		),
	"save_component_color" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

/* file: data_input.php, action: edit */
$fields_data_input_edit = array(
	"name" => array(
		"method" => "textbox",
		"friendly_name" => "名前",
		"description" => "データ入力メソッドの名前を指定します。",
		"value" => "|arg1:name|",
		"max_length" => "255",
		),
	"type_id" => array(
		"method" => "drop_array",
		"friendly_name" => "入力の種類",
		"description" => "データを収集する方法を選択します。",
		"value" => "|arg1:type_id|",
		"array" => $input_types,
		),
	"input_string" => array(
		"method" => "textarea",
		"friendly_name" => "入力文字列（入力の種類に「Script/Command」を選択した場合）",
		"description" => "データのやり取りをするためのスクリプトのパスを指定します。<br>スクリプトへ値を渡す場合はパスの後ろに\"&lt;[名前]&gt;\"を指定して保存した後に下の「入力フィールド」の「追加」より設定を行います。<br><br>例．IPアドレスをスクリプトに渡す場合<br><br>　　/path/to/script.pl &lt;ip&gt;<br><br><br>また、パスに\"&lt;path_cacti&gt;\"を指定するとcactiがインストールされているルートパスに変換されます。",
		"value" => "|arg1:input_string|",
		"textarea_rows" => "4",
		"textarea_cols" => "60",
		"class" => "textAreaNotes",
		"max_length" => "255",
		),
	"id" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:id|"
		),
	"save_component_data_input" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

/* file: data_input.php, action: field_edit (dropdown) */
$fields_data_input_field_edit_1 = array(
	"data_name" => array(
		"method" => "drop_array",
		"friendly_name" => "フィールド [|arg1:|]",
		"description" => "\"|arg1:|\"フィールドに関連付けるフィールドを選択します。",
		"value" => "|arg3:data_name|",
		"array" => "|arg2:|",
		)
	);

/* file: data_input.php, action: field_edit (textbox) */
$fields_data_input_field_edit_2 = array(
	"data_name" => array(
		"method" => "textbox",
		"friendly_name" => "フィールド [|arg1:|]",
		"description" => "\"|arg1:|\"フィールドの名前を指定します。",
		"value" => "|arg2:data_name|",
		"max_length" => "50",
		)
	);

/* file: data_input.php, action: field_edit */
$fields_data_input_field_edit = array(
	"name" => array(
		"method" => "textbox",
		"friendly_name" => "別名",
		"description" => "このフィールドの名前を指定します。",
		"value" => "|arg1:name|",
		"max_length" => "200",
		),
	"update_rra" => array(
		"method" => "checkbox",
		"friendly_name" => "RRDファイルを更新",
		"description" => "このフィールドからの値をRRDファイルに入力する場合はチェックボックスをオンにします。",
		"value" => "|arg1:update_rra|",
		"default" => "on",
		"form_id" => "|arg1:id|"
		),
	"regexp_match" => array(
		"method" => "textbox",
		"friendly_name" => "正規表現",
		"description" => "もし正規表現を使って入力データをマッチさせたいと考えている場合はここに入力してください（eregの書式で指定します）",
		"value" => "|arg1:regexp_match|",
		"max_length" => "200",
		"size" => "70"
		),
	"allow_nulls" => array(
		"method" => "checkbox",
		"friendly_name" => "空の値を許可する",
		"description" => "このフィールドに空の値を指定しても構わない場合はチェックボックスをオンにします。",
		"value" => "|arg1:allow_nulls|",
		"default" => "",
		"form_id" => false
		),
	"type_code" => array(
		"method" => "textbox",
		"friendly_name" => "特別なコード",
		"description" => "このフィールドがホストテンプレートで扱われる場合はここで指定します。<br><br>指定可能なキーワード:<br> " . (str_replace(")", "'", str_replace("(", "&nbsp;'", str_replace("|", "',<br>&nbsp;'", VALID_HOST_FIELDS)))),
		"value" => "|arg1:type_code|",
		"max_length" => "40"
		),
	"id" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:id|"
		),
	"input_output" => array(
		"method" => "hidden",
		"value" => "|arg2:|"
		),
	"sequence" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:sequence|"
		),
	"data_input_id" => array(
		"method" => "hidden_zero",
		"value" => "|arg3:data_input_id|"
		),
	"save_component_field" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

/* file: data_templates.php, action: template_edit */
$fields_data_template_template_edit = array(
	"template_name" => array(
		"method" => "textbox",
		"friendly_name" => "名前",
		"description" => "データテンプレートの名前を指定します。",
		"value" => "|arg1:name|",
		"max_length" => "150",
		),
	"data_template_id" => array(
		"method" => "hidden_zero",
		"value" => "|arg2:data_template_id|"
		),
	"data_template_data_id" => array(
		"method" => "hidden_zero",
		"value" => "|arg2:id|"
		),
	"current_rrd" => array(
		"method" => "hidden_zero",
		"value" => "|arg3:view_rrd|"
		),
	"save_component_template" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

/* file: (data_sources.php|data_templates.php), action: (ds|template)_edit */
$struct_data_source = array(
	"name" => array(
		"friendly_name" => "名前",
		"method" => "textbox",
		"max_length" => "250",
		"default" => "",
		"description" => "データソースの名前を選択します。",
		"flags" => ""
		),
	"data_source_path" => array(
		"friendly_name" => "データソースのパス",
		"method" => "textbox",
		"max_length" => "255",
		"default" => "",
		"description" => "RRDファイルがあるパスを指定します。",
		"flags" => "NOTEMPLATE"
		),
	"data_input_id" => array(
		"friendly_name" => "データ入力メソッド",
		"method" => "drop_sql",
		"sql" => "select id,name from data_input order by name",
		"default" => "",
		"none_value" => "なし",
		"description" => "データソースのデータを収集するスクリプトまたはソースを指定します。",
		"flags" => "ALWAYSTEMPLATE"
		),
	"rra_id" => array(
		"method" => "drop_multi_rra",
		"friendly_name" => "関連するラウンドロビンアーカイブ（RRA）の設定",
		"description" => "データを入力する時のRRA（データの保存期間）を選択します(特別なことがない限りはすべて選択します)<br>※不要な値が選択されている場合は\"Ctrl\"キーを押しながらクリックすることで個別に選択／解除が出来ます。",
		"form_id" => "|arg1:id|",
		"sql" => "select rra_id as id,data_template_data_id from data_template_data_rra where data_template_data_id=|arg1:id|",
		"sql_all" => "select rra.id from rra order by id",
		"sql_print" => "select rra.name from (data_template_data_rra,rra) where data_template_data_rra.rra_id=rra.id and data_template_data_rra.data_template_data_id=|arg1:id|",
		"flags" => "ALWAYSTEMPLATE"
		),
	"rrd_step" => array(
		"friendly_name" => "ステップ数",
		"method" => "textbox",
		"max_length" => "10",
		"size" => "20",
		"default" => "300",
		"description" => "更新間隔の時間を指定します。（単位：秒）",
		"flags" => ""
		),
	"active" => array(
		"friendly_name" => "データソースの動作",
		"method" => "checkbox",
		"default" => "on",
		"description" => "データソースでこのテンプレートを使用した際にPollerでデータの収集を行うようにする場合はチェックボックスをオンにします。",
		"flags" => ""
		)
	);

/* file: (data_sources.php|data_templates.php), action: (ds|template)_edit */
$struct_data_source_item = array(
	"data_source_name" => array(
		"friendly_name" => "内部で使用するデータソースの名前",
		"method" => "textbox",
		"max_length" => "19",
		"default" => "",
		"description" => "RRDファイルで使用するためのユニークな名前を指定します。"
		),
	"rrd_minimum" => array(
		"friendly_name" => "最小値（'U'を指定すると無制限になります）",
		"method" => "textbox",
		"max_length" => "20",
		"size" => "30",
		"default" => "0",
		"description" => "収集するデータとして有効な値の最小値を指定します。"
		),
	"rrd_maximum" => array(
		"friendly_name" => "最大値（'U'を指定すると無制限になります）",
		"method" => "textbox",
		"max_length" => "20",
		"size" => "30",
		"default" => "0",
		"description" => "収集するデータとして有効な値の最大値を指定します。"
		),
	"data_source_type_id" => array(
		"friendly_name" => "データソースの種類",
		"method" => "drop_array",
		"array" => $data_source_types,
		"default" => "",
		"description" => "ラウンドロビンアーカイブ（RRA）で扱うデータの種類を指定します。".
						"<br>[設定値]<br>".
						"<div style=\"margin-left: 5px;\">・<span style=\"font-weight: bold; border-bottom: 1px solid #000000;\">GAUGE：</span></div>".
						"<div style=\"padding: 3px 0px 5px 15px;\">温度や現在のユーザー数などの取得したデータをそのまま利用します。</div>".
						"<div style=\"margin-left: 5px;\">・<span style=\"font-weight: bold; border-bottom: 1px solid #000000;\">COUNTER：</span></div>".
						"<div style=\"padding: 3px 0px 5px 15px;\">通信データなどの連続して増加するカウンターとして利用します。データは減少しないことが前提で、得られたデータは毎秒当たりとして記録されます。</div>".
						"<div style=\"margin-left: 5px;\">・<span style=\"font-weight: bold; border-bottom: 1px solid #000000;\">DERIVE：</span></div>".
						"<div style=\"padding: 3px 0px 5px 15px;\">入退室した人数などのデータが増減するカウンターで利用します。オーバーフローのチェックは行われません。</div>".
						"<div style=\"margin-left: 5px;\">・<span style=\"font-weight: bold; border-bottom: 1px solid #000000;\">ABSOLUTE：</span></div>".
						"<div style=\"padding: 3px 0px 5px 15px;\">COUNTERと同じ動作だがデータ取得時にカウンターを０にリセットします。これはオーバーフローが頻繁に起きるカウンターで利用します。</div>"
		),
	"rrd_heartbeat" => array(
		"friendly_name" => "最大許容間隔",
		"method" => "textbox",
		"max_length" => "20",
		"size" => "30",
		"default" => "600",
		"description" => "取得するデータが\"UNKNOWN\"にならない更新間隔の最大の時間を指定します。（単位：秒）(Usually 2x300=600)"
		),
	"data_input_field_id" => array(
		"friendly_name" => "出力フィールド",
		"method" => "drop_sql",
		"default" => "0",
		"description" => "このデータソースに格納する収集したデータを選択します。"
		)
	);

/* file: grprint_presets.php, action: edit */
$fields_grprint_presets_edit = array(
	"name" => array(
		"method" => "textbox",
		"friendly_name" => "名前",
		"description" => "GPRINTプリセットの名前を指定します。",
		"value" => "|arg1:name|",
		"max_length" => "50",
		),
	"gprint_text" => array(
		"method" => "textbox",
		"friendly_name" => "GPRINTの書式",
		"description" => "GPRINTの任意の値を書式付き文字列で入力します。",
		"value" => "|arg1:gprint_text|",
		"max_length" => "50",
		),
	"id" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:id|"
		),
	"save_component_gprint_presets" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

/* file: (graphs.php|graph_templates.php), action: (graph|template)_edit */
$struct_graph = array(
	"title" => array(
		"friendly_name" => "タイトル (--title)",
		"method" => "textbox",
		"max_length" => "255",
		"default" => "",
		"description" => "グラフの上部に表示される名前（タイトル）を指定します。"
		),
	"image_format_id" => array(
		"friendly_name" => "画像形式 (--imgformat)",
		"method" => "drop_array",
		"array" => $image_types,
		"default" => "1",
		"description" => "生成するグラフの画像形式を指定します。指定できる形式は\"PNG\",\"GIF\"または\"SVG\"です。尚、選択できる画像形式はRRDToolに依存してます。"
		),
	"height" => array(
		"friendly_name" => "高さ (--height)",
		"method" => "textbox",
		"max_length" => "50",
		"default" => "120",
		"description" => "グラフの高さを指定します。（単位：ピクセル）"
		),
	"width" => array(
		"friendly_name" => "幅 (--width)",
		"method" => "textbox",
		"max_length" => "50",
		"default" => "500",
		"description" => "グラフの幅を指定します。（単位：ピクセル）"
		),
	"slope_mode" => array(
		"friendly_name" => "スロープモード (--slope-mode)",
		"method" => "checkbox",
		"default" => "on",
		"description" => "グラフの曲線を滑らかにします（RRDtool-1.2.x以上で使用可能）"
		),
	"auto_scale" => array(
		"friendly_name" => "オートスケール（Y軸の自動調整）(--alt-autoscale)",
		"method" => "checkbox",
		"default" => "on",
		"description" => "グラフのY軸の上限と下限の設定を自動的に調整する場合はチェックボックスをオンにします。<br>注）もし上限と下限の設定をしていてここをチェックした場合にはその設定値は無視されます。"
		),
	"auto_scale_opts" => array(
		"friendly_name" => "オートスケールのオプション",
		"method" => "radio",
		"default" => "2",
		"description" => "[設定値] <br>".
			"<div style=\"margin-left: 5px;\"><span style=\"font-weight: bold; border-bottom: 1px solid #000000;\">--alt-autoscale：</span></div>".
			"<div style=\"padding: 3px 0px 5px 15px;\">最大値と最小値の絶対値を元に調整します。 </div>".
			"<div style=\"margin-left: 5px;\"><span style=\"font-weight: bold; border-bottom: 1px solid #000000;\">--alt-autoscale-max：</span></div>".
			"<div style=\"padding: 3px 0px 5px 15px;\">予め設定されている下限値を元に最大値のみ調整します。</div>".
			"<div style=\"margin-left: 5px;\"><span style=\"font-weight: bold; border-bottom: 1px solid #000000;\">--alt-autoscale-min：</span></div>".
			"<div style=\"padding: 3px 0px 5px 15px;\">予め設定されている上限値を元に最小値のみ調整します（RRDTool-1.2.x以上）</div>".
			"<div style=\"margin-left: 5px;\"><span style=\"font-weight: bold; border-bottom: 1px solid #000000;\">--alt-autoscale (上下限値を利用)：</span></div>".
			"<div style=\"padding: 3px 0px 5px 15px;\">予め設定されている上限と下限の値を元に調整します（デフォルト）</div>",
		"items" => array(
			0 => array(
				"radio_value" => "1",
				"radio_caption" => "\"--alt-autoscale\"を使用する"
				),
			1 => array(
				"radio_value" => "2",
				"radio_caption" => "\"--alt-autoscale-max\"を使用する"
				),
			2 => array(
				"radio_value" => "3",
				"radio_caption" => "\"--alt-autoscale-min\"を使用する（RRDTool-1.2.x以上）"
				),
			3 => array(
				"radio_value" => "4",
				"radio_caption" => "\"--alt-autoscale（上下限値を利用）\"を使用する（デフォルト）"
				)
			)
		),
	"auto_scale_log" => array(
		"friendly_name" => "対数スケール(--logarithmic)",
		"method" => "checkbox",
		"default" => "",
		"on_change" => "changeScaleLog()",
		"description" => "この機能を使うとY軸を対数目盛りにします。"
		),
	"scale_log_units" => array(
		"friendly_name" => "対数スケールのSI単位 (--units=si)",
		"method" => "checkbox",
		"default" => "",
		"description" => "指数表記の代わりにSI単位を使用します（RRDTool-1.0.xでは使用できません）<br>Note: Linear graphs use SI notation by default."
		),
	"auto_scale_rigid" => array(
		"friendly_name" => "固定範囲モード (--rigid)",
		"method" => "checkbox",
		"default" => "",
		"description" => "グラフに範囲外となるような極端な値が含まれている場合であっても上限または下限を自動的に拡張しないようにします。"
		),
	"auto_padding" => array(
		"friendly_name" => "オートパディング（テキストの自動調整）",
		"method" => "checkbox",
		"default" => "on",
		"description" => "文字とグラフのデータが並ぶようにテキストを自動的に調整します。<br>注）これはグラフの描画にかかる時間が長くなる可能性があります。また、すべてのグラフにおいて正確に機能することを保障することは出来ません。"
		),
	"export" => array(
		"friendly_name" => "グラフエクスポートの許可",
		"method" => "checkbox",
		"default" => "on",
		"description" => "Cactiのエクスポート機能を使用して静的なHTML/イメージをエクスポート出来るようにするかどうかの許可を指定します。"
		),
	"upper_limit" => array(
		"friendly_name" => "上限値 (--upper-limit)",
		"method" => "textbox",
		"max_length" => "50",
		"default" => "100",
		"description" => "グラフのY軸の上限値を指定します。"
		),
	"lower_limit" => array(
		"friendly_name" => "下限値 (--lower-limit)",
		"method" => "textbox",
		"max_length" => "255",
		"default" => "0",
		"description" => "グラフのY軸の下限値を指定します。"
		),
	"base_value" => array(
		"friendly_name" => "底 (--base)",
		"method" => "textbox",
		"max_length" => "50",
		"default" => "1000",
		"description" => "トラフィック測定の場合、底として\"1000\"を指定することで&nbsp;1kB/s&nbsp;=&nbsp;1000b/s&nbsp;となり、メモリーの場合は\"1024\"を指定することで&nbsp;1kB&nbsp;=&nbsp;1024B&nbsp;となります。"
		),
	"unit_value" => array(
		"friendly_name" => "グリッド (--unit/--y-grid)",
		"method" => "textbox",
		"max_length" => "50",
		"default" => "",
		"description" => "Y軸のグリッドを指定します。空白にした場合は自動で設定されます。<br><br>
			注）この機能はRRDTool-1.0.36で追加されましたが、1.2.xでは\"--y-grid\"オプションに置き換えられています。ここで指定された値によりY軸の主線と副線を表示します。指定する値の表記は「グリッド:ラベル」となり、グリッドの倍数で副線を、「グリッド」×「ラベル」の倍数ごとに主線をそれぞれ表示します。<br><br>
			例.温度のグラフで&nbsp;1:5&nbsp;を指定した場合<br>
			　１℃ごとに副線を引き、５℃（１×５）ごとに主線を引く。"
		),
	"unit_exponent_value" => array(
		"friendly_name" => "指数 (--units-exponent)",
		"method" => "textbox",
		"max_length" => "50",
		"default" => "",
		"description" => "Y軸の値を10の累乗で拡大縮小を行います。ここを空白などの場合は自動的に単位(K,Mなど)が調整されますが、それを固定したい場合にここに適切な値を指定します。指定できる値は-18から18の3の倍数である必要があり、3を指定した場合はK（キロ:10の3乗）になり、-6を指定した場合はu（マイクロ）となります。単位をつけない場合は0を指定します。"
		),
	"vertical_label" => array(
		"friendly_name" => "Y軸のラベル (--vertical-label)",
		"method" => "textbox",
		"max_length" => "255",
		"default" => "",
		"description" => "Y軸に表示するラベルを指定します。"
		)
	);

/* file: (graphs.php|graph_templates.php), action: item_edit */
$struct_graph_item = array(
	"task_item_id" => array(
		"friendly_name" => "データソース",
		"method" => "drop_sql",
		"sql" => "select
			CONCAT_WS('',case when host.description is null then 'No Host' when host.description is not null then host.description end,' - ',data_template_data.name,' (',data_template_rrd.data_source_name,')') as name,
			data_template_rrd.id
			from (data_template_data,data_template_rrd,data_local)
			left join host on (data_local.host_id=host.id)
			where data_template_rrd.local_data_id=data_local.id
			and data_template_data.local_data_id=data_local.id
			order by name",
		"default" => "0",
		"none_value" => "なし",
		"description" => "このグラフに使うデータソースを選択します。"
		),
	"color_id" => array(
		"friendly_name" => "色",
		"method" => "drop_color",
		"default" => "0",
		"on_change" => "changeColorId()",
		"description" => "グラフの色を指定します。"
		),
	"alpha" => array(
		"friendly_name" => "不透明度",
		"method" => "drop_array",
		"default" => "FF",
		"array" => $graph_color_alpha,
		"description" => "色の不透明度を指定します（RRDTool-1.0.xでは利用できません）"
		),
	"graph_type_id" => array(
		"friendly_name" => "グラフ項目の種類",
		"method" => "drop_array",
		"array" => $graph_item_types,
		"default" => "0",
		"description" => "グラフ項目の種類を選択します。<br><br>
		[選択できる値]<br>
		　COMMENT: グラフにコメントを表示します。<br>
		　HRULE: グラフに水平線を表示します。<br>
		　VRULE: グラフに垂直の線を表示します。<br>
		　LINE1: 折線グラフ(細線)。<br>
		　LINE2: 折線グラフ(中線)。<br>
		　LINE3: 折線グラフ(太線)。<br>
		　AREA: 棒グラフ。<br>
		　STACK: 直前のグラフに重ねて表示します。種類は直前のグラフに依存するため最初には指定できません。<br>
		　GPRINT: グラフの下に予め決められた書式に沿って文字列を表示します。<br>
		　LEGEND: 現在値、平均値、最大値の凡例をGPRINTで設定します。<br>"
		),
	"consolidation_function_id" => array(
		"friendly_name" => "統合値の種類",
		"method" => "drop_array",
		"array" => $consolidation_functions,
		"default" => "0",
		"description" => "グラフ上に表示する統合値の種類を選択します。<br><br>
		[選択できる値]<br>
		 　AVERAGE: 平均値を表示します。<br>
		 　MIN: 最小値を表示します。<br>
		 　MAX: 最大値を表示します。<br>
		 　LAST: 直近の値を表示します。"
		),
	"cdef_id" => array(
		"friendly_name" => "CDEF",
		"method" => "drop_sql",
		"sql" => "select id,name from cdef order by name",
		"default" => "0",
		"none_value" => "なし",
		"description" => "グラフ上のデータにCEDF(数式)を使って表示する場合はここを選択します。"
		),
	"value" => array(
		"friendly_name" => "HRULE/VRULEの値",
		"method" => "textbox",
		"max_length" => "50",
		"default" => "",
		"description" => "グラフ項目の種類に「HRULE」または「VRULE」を選択した場合に、表示する位置となる数値を指定します。"
		),
	"gprint_id" => array(
		"friendly_name" => "GPRINTの種類",
		"method" => "drop_sql",
		"sql" => "select id,name from graph_templates_gprint order by name",
		"default" => "2",
		"description" => "グラフ項目の種類が「GPRINT」の場合、ここにGPRINTの書式を選択します。最適な設定がない場合は\"GPRINTプリセット\"で書式を追加することが出来ます。"
		),
	"text_format" => array(
		"friendly_name" => "テキスト",
		"method" => "textbox",
		"max_length" => "255",
		"default" => "",
		"description" => "グラフ項目の種類で選択した値に対する文字列を指定します。「LINE1」などのグラフを指定した場合は凡例をグラフ下部に表示します。"
		),
	"hard_return" => array(
		"friendly_name" => "改行の挿入",
		"method" => "checkbox",
		"default" => "",
		"description" => "テキストで指定した文字列の最後に改行を挿入します。"
		),
	"sequence" => array(
		"friendly_name" => "シーケンス番号（順序）",
		"method" => "view"
		)
	);

/* file: graph_templates.php, action: template_edit */
$fields_graph_template_template_edit = array(
	"name" => array(
		"method" => "textbox",
		"friendly_name" => "名前",
		"description" => "グラフテンプレートの名前を指定します。",
		"value" => "|arg1:name|",
		"max_length" => "150",
		),
	"graph_template_id" => array(
		"method" => "hidden_zero",
		"value" => "|arg2:graph_template_id|"
		),
	"graph_template_graph_id" => array(
		"method" => "hidden_zero",
		"value" => "|arg2:id|"
		),
	"save_component_template" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

/* file: graph_templates.php, action: input_edit */
$fields_graph_template_input_edit = array(
	"name" => array(
		"method" => "textbox",
		"friendly_name" => "名前",
		"description" => "グラフ項目の補足設定の名前を指定します。",
		"value" => "|arg1:name|",
		"max_length" => "50"
		),
	"description" => array(
		"method" => "textarea",
		"friendly_name" => "説明",
		"description" => "補足設定の説明を指定します。",
		"value" => "|arg1:description|",
		"textarea_rows" => "5",
		"textarea_cols" => "40"
		),
	"column_name" => array(
		"method" => "drop_array",
		"friendly_name" => "フィールドの種類",
		"description" => "補足設定を行うグラフのフィールドを選択します。",
		"value" => "|arg1:column_name|",
		"array" => "|arg2:|",
		),
	"graph_template_id" => array(
		"method" => "hidden_zero",
		"value" => "|arg3:graph_template_id|"
		),
	"graph_template_input_id" => array(
		"method" => "hidden_zero",
		"value" => "|arg3:id|"
		),
	"save_component_input" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

/* file: host.php, action: edit */
$fields_host_edit = array(
	"host_header" => array(
		"method" => "spacer",
		"friendly_name" => "一般設定"
		),
	"description" => array(
		"method" => "textbox",
		"friendly_name" => "名前",
		"description" => "このホストの名前を指定します。ここで指定した名前はグラフ上部に表示されるタイトルにも使用されます。",
		"value" => "|arg1:description|",
		"max_length" => "250",
		),
	"hostname" => array(
		"method" => "textbox",
		"friendly_name" => "ホスト名／IPアドレス",
		"description" => "このデバイスをホスト名（FQDN形式）またはIPアドレスで指定します。",
		"value" => "|arg1:hostname|",
		"max_length" => "250",
		),
	"host_template_id" => array(
		"method" => "drop_sql",
		"friendly_name" => "ホストテンプレート",
		"description" => "このホストと関連するグラフテンプレートとデータクエリを定義しているホストテンプレートを選択します。",
		"value" => "|arg1:host_template_id|",
		"none_value" => "なし",
		"sql" => "select id,name from host_template order by name",
		),
	"device_threads" => array(
		"method" => "drop_array",
		"friendly_name" => "収集スレッドの数",
		"description" => "データを収集するために同時に実行するスレッドの数を指定します（Spine利用時のみ）",
		"value" => "|arg1:device_threads|",
		"default" => "1",
		"array" => $device_threads
		),
	"disabled" => array(
		"method" => "checkbox",
		"friendly_name" => "ホストの無効化",
		"description" => "このホストを無効にする場合はこのチェックボックスをオンにします。",
		"value" => "|arg1:disabled|",
		"default" => "",
		"form_id" => false
		),
	"availability_header" => array(
		"method" => "spacer",
		"friendly_name" => "有効性／到達手段の設定"
		),
	"availability_method" => array(
		"friendly_name" => "ダウン状態の検出方法",
		"description" => "ホストが利用可能であるかどうかを調べるための方法を選択します。<br><i>注）最低限、SNMPは選択しておくことを推奨します。</i>",
		"on_change" => "changeHostForm()",
		"value" => "|arg1:availability_method|",
		"method" => "drop_array",
		"default" => read_config_option("availability_method"),
		"array" => $availability_options
		),
	"ping_method" => array(
		"friendly_name" => "Pingの種類",
		"description" => "送信するPingのパケットの種類を選択します。<br><i>注）LinuxまたはUNIXでICMPを利用する場合はルート権限が必要になります。</i>",
		"on_change" => "changeHostForm()",
		"value" => "|arg1:ping_method|",
		"method" => "drop_array",
		"default" => read_config_option("ping_method"),
		"array" => $ping_methods
		),
	"ping_port" => array(
		"method" => "textbox",
		"friendly_name" => "Pingのポート番号",
		"value" => "|arg1:ping_port|",
		"description" => "接続するTCPまたはUDPのポート番号を指定します。",
		"default" => read_config_option("ping_port"),
		"max_length" => "50",
		"size" => "15"
		),
	"ping_timeout" => array(
		"friendly_name" => "Pingのタイムアウト",
		"description" => "ICMPとUDPによるPingを使ったときの応答の待ち時間（ミリ秒）を指定します。SNMPによるPingの場合はSNMPに対するタイムアウトの時間になります。",
		"method" => "textbox",
		"value" => "|arg1:ping_timeout|",
		"default" => read_config_option("ping_timeout"),
		"max_length" => "10",
		"size" => "15"
		),
	"ping_retries" => array(
		"friendly_name" => "Pingの再試行回数",
		"description" => "失敗したときに再度Pingを行う回数を指定します。この回数を超えるとエラーとなります。",
		"method" => "textbox",
		"value" => "|arg1:ping_retries|",
		"default" => read_config_option("ping_retries"),
		"max_length" => "10",
		"size" => "15"
		),
	"spacer1" => array(
		"method" => "spacer",
		"friendly_name" => "SNMPの設定"
		),
	"snmp_version" => array(
		"method" => "drop_array",
		"friendly_name" => "SNMPのバージョン",
		"description" => "利用可能なSNMPのバージョンを選択します。",
		"on_change" => "changeHostForm()",
		"value" => "|arg1:snmp_version|",
		"default" => read_config_option("snmp_ver"),
		"array" => $snmp_versions,
		),
	"snmp_community" => array(
		"method" => "textbox",
		"friendly_name" => "SNMPのコミュニティ名",
		"description" => "読み込み可能なコミュニティ名を指定します。",
		"value" => "|arg1:snmp_community|",
		"form_id" => "|arg1:id|",
		"default" => read_config_option("snmp_community"),
		"max_length" => "100",
		"size" => "15"
		),
	"snmp_username" => array(
		"method" => "textbox",
		"friendly_name" => "SNMPのユーザー名（バージョン3のみ）",
		"description" => "ユーザー名を指定します。",
		"value" => "|arg1:snmp_username|",
		"default" => read_config_option("snmp_username"),
		"max_length" => "50",
		"size" => "15"
		),
	"snmp_password" => array(
		"method" => "textbox_password",
		"friendly_name" => "SNMPのパスワード（バージョン3のみ）",
		"description" => "認証に利用するためのパスワードを指定します。",
		"value" => "|arg1:snmp_password|",
		"default" => read_config_option("snmp_password"),
		"max_length" => "50",
		"size" => "15"
		),
	"snmp_auth_protocol" => array(
		"method" => "drop_array",
		"friendly_name" => "SNMPの認証用プロトコル（バージョン3のみ）",
		"description" => "認証に利用するためのプロトコルを選択します。",
		"value" => "|arg1:snmp_auth_protocol|",
		"default" => read_config_option("snmp_auth_protocol"),
		"array" => $snmp_auth_protocols,
		),
	"snmp_priv_passphrase" => array(
		"method" => "textbox",
		"friendly_name" => "SNMPのプライバシーパスフレーズ（バージョン3のみ）",
		"description" => "メッセージの暗号化に利用するためのプライバシーパスフレーズを指定します。",
		"value" => "|arg1:snmp_priv_passphrase|",
		"default" => read_config_option("snmp_priv_passphrase"),
		"max_length" => "200",
		"size" => "40"
		),
	"snmp_priv_protocol" => array(
		"method" => "drop_array",
		"friendly_name" => "SNMPのプライバシープロトコル（バージョン3のみ）",
		"description" => "メッセージの暗号化に利用するためのプライバシープロトコルを指定します。",
		"value" => "|arg1:snmp_priv_protocol|",
		"default" => read_config_option("snmp_priv_protocol"),
		"array" => $snmp_priv_protocols,
		),
	"snmp_context" => array(
		"method" => "textbox",
		"friendly_name" => "SNMPコンテキスト",
		"description" => "SNMPコンテキストを利用する場合はここに指定します。",
		"value" => "|arg1:snmp_context|",
		"default" => "",
		"max_length" => "64",
		"size" => "25"
		),
	"snmp_port" => array(
		"method" => "textbox",
		"friendly_name" => "SNMPのポート番号",
		"description" => "SNMPで利用するUPDのポート番号を指定します（デフォルト: 161）",
		"value" => "|arg1:snmp_port|",
		"max_length" => "5",
		"default" => read_config_option("snmp_port"),
		"size" => "15"
		),
	"snmp_timeout" => array(
		"method" => "textbox",
		"friendly_name" => "SNMPのタイムアウト",
		"description" => "SNMPからの応答を待つ時間（ミリ秒）を指定します。<br>（※php-snmpオプションを有効にしていないと動作しません）",
		"value" => "|arg1:snmp_timeout|",
		"max_length" => "8",
		"default" => read_config_option("snmp_timeout"),
		"size" => "15"
		),
	"max_oids" => array(
		"method" => "textbox",
		"friendly_name" => "リクエストあたりの受け取るOIDの最大値",
		"description" => "１つのSNMPからのリクエストで受け取ることが出来るOIDの数を指定します（Spine利用時のみ）<br>注）いくつかのデバイスは１よりも大きい値をサポートしない可能性があります。<br>",
		"value" => "|arg1:max_oids|",
		"max_length" => "8",
		"default" => read_config_option("max_get_size"),
		"size" => "15"
		),
	"header4" => array(
		"method" => "spacer",
		"friendly_name" => "追加設定"
		),
	"notes" => array(
		"method" => "textarea",
		"friendly_name" => "メモ",
		"description" => "ホストに関するメモを残す場合はここに入力します。",
		"class" => "textAreaNotes",
		"value" => "|arg1:notes|",
		"textarea_rows" => "5",
		"textarea_cols" => "50"
		),
	"id" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:id|"
		),
	"_host_template_id" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:host_template_id|"
		),
	"save_component_host" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

/* file: host_templates.php, action: edit */
$fields_host_template_edit = array(
	"name" => array(
		"method" => "textbox",
		"friendly_name" => "名前",
		"description" => "ホストテンプレートの名前を指定します。",
		"value" => "|arg1:name|",
		"max_length" => "255",
		),
	"id" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:id|"
		),
	"save_component_template" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

/* file: rra.php, action: edit */
$fields_rra_edit = array(
	"name" => array(
		"method" => "textbox",
		"friendly_name" => "名前",
		"description" => "RRAの名前を指定します。",
		"value" => "|arg1:name|",
		"max_length" => "100",
		),
	"consolidation_function_id" => array(
		"method" => "drop_multi",
		"friendly_name" => "統合値の種類",
		"description" => "RRAで利用する統合値の種類を選択します。",
		"array" => $consolidation_functions,
		"sql" => "select consolidation_function_id as id,rra_id from rra_cf where rra_id=|arg1:id|",
		),
	"x_files_factor" => array(
		"method" => "textbox",
		"friendly_name" => "未定義値の許容率",
		"description" => "統合値に含まれる「*UNKNOWN*」の割合がどれだけ以下であれば未定義値とするかを指定します。通常は\"0.5\"で十分です。",
		"value" => "|arg1:x_files_factor|",
		"max_length" => "10",
		),
	"steps" => array(
		"method" => "textbox",
		"friendly_name" => "ステップ数",
		"description" => "RRAに格納する統合値を構成するための基準となるデータの数を指定します。したがって、「--stepオプションで指定された時間」×「ここのステップ数」を元に統合値の処理を行います。",
		"value" => "|arg1:steps|",
		"max_length" => "8",
		),
	"rows" => array(
		"method" => "textbox",
		"friendly_name" => "データ数",
		"description" => "RRAに保存する統合値の数を指定します。<br><br>例.「統合値の種類: AVERAGE」「--step: 300」、「ステップ数: 1」、「データ数: 1752」とした場合<br>　300秒×1個のデータの平均値を1725個（約1年分）記録する",
		"value" => "|arg1:rows|",
		"max_length" => "12",
		),
	"timespan" => array(
		"method" => "textbox",
		"friendly_name" => "タイムスパン",
		"description" => "RRAの基準データとなるタイムスパンを指定します。",
		"value" => "|arg1:timespan|",
		"max_length" => "12",
		),
	"id" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:id|"
		),
	"save_component_rra" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

/* file: data_queries.php, action: edit */
$fields_data_query_edit = array(
	"name" => array(
		"method" => "textbox",
		"friendly_name" => "名前",
		"description" => "データクエリの名前を指定します。",
		"value" => "|arg1:name|",
		"max_length" => "100",
		),
	"description" => array(
		"method" => "textbox",
		"friendly_name" => "説明",
		"description" => "このデータクエリの説明を指定します。",
		"value" => "|arg1:description|",
		"size" => "80",
		"max_length" => "255",
		),
	"xml_path" => array(
		"method" => "textbox",
		"friendly_name" => "XMLファイルのパス",
		"description" => "データクエリのためのXMLファイルがあるパスを指定します。",
		"value" => "|arg1:xml_path|",
		"default" => "<path_cacti>/resource/",
		"size" => "80",
		"max_length" => "255",
		),
	"data_input_id" => array(
		"method" => "drop_sql",
		"friendly_name" => "データ入力メソッド",
		"description" => "データクエリのための入力メソッドを選択します。 この入力メソッドはデータクエリによってホストからデータをどのように収集するかを定義します。",
		"value" => "|arg1:data_input_id|",
		"sql" => "select id,name from data_input where (type_id=3 or type_id=4 or type_id=5 or type_id=6) order by name",
		),
	"id" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:id|",
		),
	"save_component_snmp_query" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

/* file: data_queries.php, action: item_edit */
$fields_data_query_item_edit = array(
	"name" => array(
		"method" => "textbox",
		"friendly_name" => "名前",
		"description" => "関連するグラフの名前を指定します。",
		"value" => "|arg1:name|",
		"max_length" => "100",
		),
	"graph_template_id" => array(
		"method" => "drop_sql",
		"friendly_name" => "グラフテンプレート",
		"description" => "このデータクエリで使用するグラフテンプレートを選択してください。",
		"value" => "|arg1:graph_template_id|",
		"sql" => "select id,name from graph_templates order by name",
		),
	"id" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:id|"
		),
	"snmp_query_id" => array(
		"method" => "hidden_zero",
		"value" => "|arg2:snmp_query_id|"
		),
	"_graph_template_id" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:graph_template_id|"
		),
	"save_component_snmp_query_item" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

/* file: tree.php, action: edit */
$fields_tree_edit = array(
	"name" => array(
		"method" => "textbox",
		"friendly_name" => "名前",
		"description" => "グラフツリーの名前を指定します。",
		"value" => "|arg1:name|",
		"max_length" => "255",
		),
	"sort_type" => array(
		"method" => "drop_array",
		"friendly_name" => "並べ替えの種類",
		"description" => "このツリーで登録している項目の並び順を選択します。",
		"value" => "|arg1:sort_type|",
		"array" => $tree_sort_types,
		),
	"id" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:id|"
		),
	"save_component_tree" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

/* file: user_admin.php, action: user_edit (host) */
$fields_user_user_edit_host = array(
	"username" => array(
		"method" => "textbox",
		"friendly_name" => "ユーザー名",
		"description" => "ユーザーのログイン名を指定します。",
		"value" => "|arg1:username|",
		"max_length" => "255"
		),
	"full_name" => array(
		"method" => "textbox",
		"friendly_name" => "フルネーム",
		"description" => "ユーザーの名前を指定します。文字列には特殊文字や空白（スペース）を含めることが出来ます。",
		"value" => "|arg1:full_name|",
		"max_length" => "255"
		),
	"password" => array(
		"method" => "textbox_password",
		"friendly_name" => "パスワード",
		"description" => "ユーザーのパスワードを確認も含めて２回指定します。また、大文字と小文字は別々に扱われますので注意してください。",
		"value" => "",
		"max_length" => "255"
		),
	"enabled" => array(
		"method" => "checkbox",
		"friendly_name" => "ユーザーの有効",
		"description" => "ユーザーがログインできるようにする場合はここのチェックボックスをオンにします。",
		"value" => "|arg1:enabled|",
		"default" => ""
		),
	"grp1" => array(
		"friendly_name" => "アカウントオプション",
		"method" => "checkbox_group",
		"description" => "ユーザーのアカウントに関する固有のオプションを設定します。",
		"items" => array(
			"must_change_password" => array(
				"value" => "|arg1:must_change_password|",
				"friendly_name" => "次回ログイン時にパスワードの変更を要求します。",
				"form_id" => "|arg1:id|",
				"default" => ""
				),
			"graph_settings" => array(
				"value" => "|arg1:graph_settings|",
				"friendly_name" => "グラフで設定した内容を保持するようにします。",
				"form_id" => "|arg1:id|",
				"default" => "on"
				)
			)
		),
	"grp2" => array(
		"friendly_name" => "グラフオプション",
		"method" => "checkbox_group",
		"description" => "グラフに関する固有のオプションを設定します。",
		"items" => array(
			"show_tree" => array(
				"value" => "|arg1:show_tree|",
				"friendly_name" => "ツリー表示を許可します。",
				"form_id" => "|arg1:id|",
				"default" => "on"
				),
			"show_list" => array(
				"value" => "|arg1:show_list|",
				"friendly_name" => "リスト表示を許可します。",
				"form_id" => "|arg1:id|",
				"default" => "on"
				),
			"show_preview" => array(
				"value" => "|arg1:show_preview|",
				"friendly_name" => "プレビュー表示を許可します。",
				"form_id" => "|arg1:id|",
				"default" => "on"
				)
			)
		),
	"login_opts" => array(
		"friendly_name" => "ログインオプション",
		"method" => "radio",
		"default" => "1",
		"description" => "ログイン後の動作を設定します。",
		"value" => "|arg1:login_opts|",
		"items" => array(
			0 => array(
				"radio_value" => "1",
				"radio_caption" => "ユーザー側のブラウザが指し示すページを表示します。"
				),
			1 => array(
				"radio_value" => "2",
				"radio_caption" => "コンソール画面を表示します。"
				),
			2 => array(
				"radio_value" => "3",
				"radio_caption" => "グラフ画面を表示します。"
				)
			)
		),
	"realm" => array(
		"method" => "drop_array",
		"friendly_name" => "認証領域",
		"description" => "「LDAP」と「Web Basic」は予め認証が出来る環境にしてから選択する必要があります。もし認証できない環境でこれらを選択した場合、ユーザー認証が行えなくなりますので注意してください。",
		"value" => "|arg1:realm|",
		"default" => 0,
		"array" => $auth_realms,
		),
	"id" => array(
		"method" => "hidden_zero",
		"value" => "|arg1:id|"
		),
	"_policy_graphs" => array(
		"method" => "hidden",
		"default" => "2",
		"value" => "|arg1:policy_graphs|"
		),
	"_policy_trees" => array(
		"method" => "hidden",
		"default" => "2",
		"value" => "|arg1:policy_trees|"
		),
	"_policy_hosts" => array(
		"method" => "hidden",
		"default" => "2",
		"value" => "|arg1:policy_hosts|"
		),
	"_policy_graph_templates" => array(
		"method" => "hidden",
		"default" => "2",
		"value" => "|arg1:policy_graph_templates|"
		),
	"save_component_user" => array(
		"method" => "hidden",
		"value" => "1"
		)
	);

$export_types = array(
	"graph_template" => array(
		"name" => "グラフテンプレート",
		"title_sql" => "select name from graph_templates where id=|id|",
		"dropdown_sql" => "select id,name from graph_templates order by name"
		),
	"data_template" => array(
		"name" => "データテンプレート",
		"title_sql" => "select name from data_template where id=|id|",
		"dropdown_sql" => "select id,name from data_template order by name"
		),
	"host_template" => array(
		"name" => "ホストテンプレート",
		"title_sql" => "select name from host_template where id=|id|",
		"dropdown_sql" => "select id,name from host_template order by name"
		),
	"data_query" => array(
		"name" => "データクエリ",
		"title_sql" => "select name from snmp_query where id=|id|",
		"dropdown_sql" => "select id,name from snmp_query order by name"
		)
	);

$fields_template_import = array(
	"import_file" => array(
		"friendly_name" => "ローカルマシンからテンプレートをインポート",
		"description" => "テンプレートデータを含むXMLファイルをインポートする場合はこちらからローカルマシン上のパスを選択してください。",
		"method" => "file"
		),
	"import_text" => array(
		"method" => "textarea",
		"friendly_name" => "テキストからテンプレートをインポート",
		"description" => "XMLファイルではなくテキストとしてインポートする場合はこちらからテンプレートデータを含むテキストをボックス内へペーストしてください。",
		"value" => "",
		"default" => "",
		"textarea_rows" => "10",
		"textarea_cols" => "50",
		"class" => "textAreaNotes"
		),
	"import_rra" => array(
		"friendly_name" => "インポートするRRAの設定",
		"description" => "インポートするテンプレートにRRAの設定が記述されていたときにこれを読み込むかどうかを選択します。",
		"method" => "radio",
		"value" => "",
		"default" => "1",
		"on_change" => "changeRRA()",
		"items" => array(
			0 => array(
				"radio_value" => "1",
				"radio_caption" => "下の項目よりRRA設定を選択します（推奨）"
				),
			1 => array(
				"radio_value" => "2",
				"radio_caption" => "テンプレート内のRRA設定を使用します。"
				),
			)
		),
	"rra_id" => array(
		"method" => "drop_multi_rra",
		"friendly_name" => "関連するラウンドロビンアーカイブ（RRA）の設定",
		"description" => "データを入力する時のRRA（データの保存期間）を選択します(特別なことがない限りはすべて選択します)<br>※不要な値が選択されている場合は\"Ctrl\"キーを押しながらクリックすることで個別に選択／解除が出来ます。",
		"form_id" => "",
		"sql_all" => "select rra.id from rra where id in (1,2,3,4) order by id",
		),
	);
?>
