<?php
/*
 +-------------------------------------------------------------------------+
 | Copyright (C) 2004-2011 The Cacti Group                                 |
 |                                                                         |
 | This program is free software; you can redistribute it and/or           |
 | modify it under the terms of the GNU General Public License             |
 | as published by the Free Software Foundation; either version 2          |
 | of the License, or (at your option) any later version.                  |
 |                                                                         |
 | This program is distributed in the hope that it will be useful,         |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of          |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           |
 | GNU General Public License for more details.                            |
 +-------------------------------------------------------------------------+
 | Cacti: The Complete RRDTool-based Graphing Solution                     |
 +-------------------------------------------------------------------------+
 | This code is designed, written, and maintained by the Cacti Group. See  |
 | about.php and/or the AUTHORS file for specific developer information.   |
 +-------------------------------------------------------------------------+
 | http://www.cacti.net/                                                   |
 +-------------------------------------------------------------------------+
*/

/* tab information */
$tabs = array(
	"general" => "一般",
	"path" => "パス",
	"poller" => "Poller",
	"export" => "グラフの書き出し（エクスポート）",
	"visual" => "表示",
	"authentication" => "認証");

$tabs_graphs = array(
	"general" => "一般",
	"thumbnail" => "グラフのサムネイル表示",
	"tree" => "ツリー表示",
	"preview" => "プレビュー表示",
	"list" => "リスト表示",
	"fonts" => "グラフのフォント（RRDtool-1.2.x以上）");

/* setting information */
$settings = array(
	"path" => array(
		"dependent_header" => array(
			"friendly_name" => "動作に必要な各ツールのパス",
			"method" => "spacer",
			),
		"path_snmpwalk" => array(
			"friendly_name" => "snmpwalkのパス",
			"description" => "snmpwalkのバイナリファイルがあるパスを指定します。",
			"method" => "filepath",
			"max_length" => "255"
			),
		"path_snmpget" => array(
			"friendly_name" => "snmpgetのパス",
			"description" => "snmpgetのバイナリファイルがあるパスを指定します。",
			"method" => "filepath",
			"max_length" => "255"
			),
		"path_snmpbulkwalk" => array(
			"friendly_name" => "snmpbulkwalkのパス",
			"description" => "snmpbulkwalkのバイナリファイルがあるパスを指定します。",
			"method" => "filepath",
			"max_length" => "255"
			),
		"path_snmpgetnext" => array(
			"friendly_name" => "snmpgetnextのパス",
			"description" => "snmpgetnextのバイナリファイルがあるパスを指定します。",
			"method" => "filepath",
			"max_length" => "255"
			),
		"path_rrdtool" => array(
			"friendly_name" => "RRDToolのパス",
			"description" => "RRDToolのバイナリファイルがあるパスを指定します。",
			"method" => "filepath",
			"max_length" => "255"
			),
		"path_rrdtool_default_font" => array(
			"friendly_name" => "RRDToolのデフォルトフォント",
			"description" => "RRDtoolのバージョンが1.2の場合は、TrueTypeフォントファイルのパスを指定します。" . "<br/><br/>" .
							"RRDtoolのバージョンが1.3以上の場合はPangoの命名規則に従ってください:" . "<br/>" .
							'【Pangoの書式】 [FAMILY-LIST] [STYLE-OPTIONS] [SIZE]<br/>' .
							'"FAMILY-LIST"はフォントを指定します（複数指定はカンマ（,）で区切ります）<br>' .
							'"STYLE_OPTIONS"は文字のスタイルを指定します（複数指定はスペースで区切ります）<br>' .
							'　[スタイルの種類]<br>' .
							'　　style: スタイル（Normal,italic,obliqueのいずれか）<br>' .
							'　　variant: スモールキャピタル(normal,smallcapsのいずれか)<br>' .
							'　　weight: 太さ(ultralightなどの4つのキーワードから１つまたは数値)<br>' .
							'　　stretch: 伸び(ultracondensedなどの9つのキーワードから１つ)<br>' .
							'　　gravity: 縦書きオプション<br>' .
							'"SIZE"は文字のサイズを数値もしくはpx修飾子を使った絶対サイズで指定します。',
			"method" => "font",
			"max_length" => "255"
			),
		"path_php_binary" => array(
			"friendly_name" => "PHPのパス",
			"description" => "PHPのバイナリファイルがあるパスを指定します（PHPのリコンパイル時に必要になります）",
			"method" => "filepath",
			"max_length" => "255"
			),
		"logging_header" => array(
			"friendly_name" => "ログに関する設定",
			"method" => "spacer",
			),
		"path_cactilog" => array(
			"friendly_name" => "Cactiのログファイルのパス",
			"description" => "Cactiのログファイルがあるパスを指定します（ここを空白にした場合はデフォルトの\"<path_cacti>/log/cacti.log\"が指定されます）",
			"method" => "filepath",
			"default" => $config["base_path"] . "/log/cacti.log",
			"max_length" => "255"
			),
		"pollerpaths_header" => array(
			"friendly_name" => "Pollerの代わりとなるバイナリに関する設定",
			"method" => "spacer",
			),
		"path_spine" => array(
			"friendly_name" => "SpineのPollerファイルのパス",
			"description" => "Spineのバイナリファイルがあるパスを指定します。",
			"method" => "filepath",
			"max_length" => "255"
			),
		"extendedpaths_header" => array(
			"friendly_name" => "RRDに関する設定",
			"method" => "spacer",
			),
		"extended_paths" => array(
			"friendly_name" => "RRDパスの階層化 (/[host_id]/[local_data_id].rrd)",
			"description" => "RRDファイルをホスト毎に階層化して管理する場合はチェックボックスをオンにします。",
			"method" => "checkbox"
 			)
		),
	"general" => array(
		"logging_header" => array(
			"friendly_name" => "ログに関する設定",
			"method" => "spacer",
			),
		"log_destination" => array(
			"friendly_name" => "ログの記録先",
			"description" => "イベントのロギング方法を選択します。",
			"method" => "drop_array",
			"default" => 1,
			"array" => $logfile_options,
			),
		"web_log" => array(
			"friendly_name" => "Webイベント",
			"description" => "ログへ記録するWebサイト上のメッセージを選択します。",
			"method" => "checkbox_group",
			"tab" => "general",
			"items" => array(
				"log_snmp" => array(
					"friendly_name" => "SNMPのメッセージ",
					"default" => ""
					),
				"log_graph" => array(
					"friendly_name" => "RRDのグラフに関する構文",
					"default" => ""
					),
				"log_export" => array(
					"friendly_name" => "グラフのエクスポート時のメッセージ",
					"default" => ""
					)
				),
			),
		"poller_header" => array(
			"friendly_name" => "Pollerの動作におけるログの設定",
			"method" => "spacer",
			),
		"log_verbosity" => array(
			"friendly_name" => "Pollerのログレベル",
			"description" => "ログに記録する情報のレベルを選択します。<br>警告: 「なし」または「低レベル」以外の値を選択した場合は大量にディスクスペースを消費するため注意してください。",
			"method" => "drop_array",
			"default" => POLLER_VERBOSITY_LOW,
			"array" => $logfile_verbosity,
			),
		"poller_log" => array(
			"friendly_name" => "Pollerの「Syslog／イベントログ」に関する設定",
			"description" => "ログの記録先に「Syslog／イベントログ」を含めている場合、「Syslog／イベントログ」に含めるPollerからのメッセージを選択します。",
			"method" => "checkbox_group",
			"tab" => "poller",
			"items" => array(
				"log_pstats" => array(
					"friendly_name" => "Pollerからの統計値",
					"default" => ""
					),
				"log_pwarn" => array(
					"friendly_name" => "Pollerからの警告",
					"default" => ""
					),
				"log_perror" => array(
					"friendly_name" => "Pollerからのエラー",
					"default" => "on"
					)
				),
			),
		"versions_header" => array(
			"friendly_name" => "動作に必要な各ツールのバージョン",
			"method" => "spacer",
			),
		"snmp_version" => array(
			"friendly_name" => "SNMPのバージョン",
			"description" => "インストールされているSNMPの種類を選択してください。もし、PHPがSNMPをサポートしていない場合は再インストールが必要になります。",
			"method" => "drop_array",
			"default" => "net-snmp",
			"array" => $snmp_implimentations,
			),
		"rrdtool_version" => array(
			"friendly_name" => "RRDToolのバージョン",
			"description" => "インストールされているRRDToolのバージョンを選択してください。",
			"method" => "drop_array",
			"default" => "rrd-1.2.x",
			"array" => $rrdtool_versions,
			),
		"snmp_header" => array(
			"friendly_name" => "SNMPのデフォルト設定",
			"method" => "spacer",
			),
		"snmp_ver" => array(
			"friendly_name" => "SNMPのバージョン",
			"description" => "利用可能なSNMPのバージョンを選択します。",
			"method" => "drop_array",
			"default" => "1",
			"array" => $snmp_versions,
			),
		"snmp_community" => array(
			"friendly_name" => "SNMPのコミュニティ名",
			"description" => "読み込み可能なコミュニティ名を指定します。",
			"method" => "textbox",
			"default" => "public",
			"max_length" => "100",
			),
		"snmp_username" => array(
			"friendly_name" => "SNMPのユーザー名（バージョン3のみ）",
			"description" => "ユーザー名を指定します。",
			"method" => "textbox",
			"default" => "",
			"max_length" => "100",
			),
		"snmp_password" => array(
			"friendly_name" => "SNMPのパスワード（バージョン3のみ）",
			"description" => "認証に利用するためのパスワードを指定します。",
			"method" => "textbox_password",
			"default" => "",
			"max_length" => "100",
			),
		"snmp_auth_protocol" => array(
			"method" => "drop_array",
			"friendly_name" => "SNMPの認証用プロトコル（バージョン3のみ）",
			"description" => "認証に利用するためのプロトコルを選択します。",
			"default" => "MD5",
			"array" => $snmp_auth_protocols,
			),
		"snmp_priv_passphrase" => array(
			"method" => "textbox",
			"friendly_name" => "SNMPのプライバシーパスフレーズ（バージョン3のみ）",
			"description" => "メッセージの暗号化に利用するためのプライバシーパスフレーズを指定します。",
			"default" => "",
			"max_length" => "200"
			),
		"snmp_priv_protocol" => array(
			"method" => "drop_array",
			"friendly_name" => "SNMPのプライバシープロトコル（バージョン3のみ）",
			"description" => "メッセージの暗号化に利用するためのプライバシープロトコルを指定します。",
			"default" => "DES",
			"array" => $snmp_priv_protocols,
			),
		"snmp_timeout" => array(
			"friendly_name" => "SNMPのタイムアウト",
			"description" => "SNMPからの応答を待つ時間（ミリ秒）を指定します。",
			"method" => "textbox",
			"default" => "500",
			"max_length" => "10",
			"size" => "5"
			),
		"snmp_port" => array(
			"friendly_name" => "SNMPのポート番号",
			"description" => "SNMPで利用するUPDのポート番号を指定します（デフォルト: 161）",
			"method" => "textbox",
			"default" => "161",
			"max_length" => "10",
			"size" => "5"
			),
		"snmp_retries" => array(
			"friendly_name" => "SNMPの再試行回数",
			"description" => "失敗したときに再度SNMP pollerを行う回数を指定します。",
			"method" => "textbox",
			"default" => "3",
			"max_length" => "10",
			"size" => "5"
			),
		"other_header" => array(
			"friendly_name" => "その他のデフォルト設定",
			"method" => "spacer",
			),
		"reindex_method" => array(
			"friendly_name" => "データクエリの再インデックス方法",
			"description" => "データクエリに対する再インデックス方法を選択します。",
			"method" => "drop_array",
			"default" => "1",
			"array" => $reindex_types,
			),
		"deletion_verification" => array(
			"friendly_name" => "削除の確認",
			"description" => "削除する前に確認を行う場合はチェックボックスをオンにします。",
			"default" => "on",
			"method" => "checkbox"
			)
		),
	"export" => array(
		"export_hdr_general" => array(
			"friendly_name" => "一般",
			"method" => "spacer",
			),
		"export_type" => array(
			"friendly_name" => "書き出し方法",
			"description" => "書き出しの方法を選択します。",
			"method" => "drop_array",
			"default" => "disabled",
			"array" => array(
						"disabled" => "無効（書き出ししない）",
						"local" => "クラシック（ローカルパス）",
						"ftp_php" => "FTP（リモート）- PHPのFTP関数を使用",
						"ftp_ncftpput" => "FTP（リモート）- ncftpputコマンドを使用",
						"sftp_php" => "SFTP（リモート）- PHPのSSH関数を使用"
						),
			),
		"export_presentation" => array(
			"friendly_name" => "プレゼンテーション方法（表示方法）",
			"description" => "生成するHTMLページのプレゼンテーションの方法を選択します。「クラシックプレゼンテーション」を選択した場合、グラフを１つのHTMLページで構成します。 また、「ツリープレゼンテーション」を選択した場合は、HTMLページの中にツリー構造でグラフを構成します。",
			"method" => "drop_array",
			"default" => "disabled",
			"array" => array(
						"classical" => "クラシックプレゼンテーション",
						"tree" => "ツリープレゼンテーション",
						),
			),
		"export_tree_options" => array(
			"friendly_name" => "ツリーに関する設定",
			"method" => "spacer",
			),
		"export_tree_isolation" => array(
			"friendly_name" => "ツリーの分離",
			"description" => "この設定はツリーの階層を個別（マルチツリー表示）するか１つ（シングルツリー表示）にまとめるかを選択します。もし個別として扱う場合はグラフもそれぞれに分離されます。",
			"method" => "drop_array",
			"default" => "off",
			"array" => array(
						"off" => "シングルツリー表示",
						"on" => "マルチツリー表示"
						),
			),
		"export_user_id" => array(
			"friendly_name" => "有効なユーザー名",
			"description" => "書き出しを行う時に利用するユーザー名を指定します。このユーザーはグラフ／ツリーを書き出す場合に使用されます。この設定は現在のテンプレート内で使用可能なON／OFF動作と共に機能します。",
			"method" => "drop_sql",
			"sql" => "SELECT id, username AS name FROM user_auth ORDER BY name",
			"default" => "1"
			),
		"export_tree_expand_hosts" => array(
			"friendly_name" => "ツリーのホストの拡張",
			"description" => "ツリーのホストを展開するかどうかを選択します。ここをOnにした場合は各ホストはデータテンプレート、またはデータクエリの項目のいずれかを含むサブフォルダ形式で構成されます。",
			"method" => "drop_array",
			"default" => "off",
			"array" => array(
						"off" => "Off",
						"on" => "On"
						),
			),
		"export_thumb_options" => array(
			"friendly_name" => "サムネイル表示に関する設定",
			"method" => "spacer",
			),
		"export_default_height" => array(
			"friendly_name" => "サムネイルの高さ",
			"description" => "サムネイル表示するグラフの高さを指定します（単位: ピクセル）",
			"method" => "textbox",
			"default" => "100",
			"max_length" => "10",
			"size" => "5"
			),
		"export_default_width" => array(
			"friendly_name" => "サムネイルの幅",
			"description" => "サムネイル表示するグラフの幅を指定します（単位: ピクセル）",
			"method" => "textbox",
			"default" => "300",
			"max_length" => "10",
			"size" => "5"
			),
		"export_num_columns" => array(
			"friendly_name" => "サムネイルの列",
			"description" => "グラフをサムネイルで表示する場合の１行あたりの列数（横に並べる数）を指定します。",
			"method" => "textbox",
			"default" => "2",
			"max_length" => "5",
			"size" => "5"
			),
		"export_hdr_paths" => array(
			"friendly_name" => "パスに関する設定",
			"method" => "spacer",
			),
		"path_html_export" => array(
			"friendly_name" => "書き出すディレクトリ（ローカルとFTP共通）",
			"description" => "リモート（FTP）システムまたは、ローカルシステム上にデータを書き出す際のディレクトリを指定します。",
			"method" => "dirpath",
			"max_length" => "255"
			),
		"export_temporary_directory" => array(
			"friendly_name" => "一時保存するローカルのディレクトリ（FTPのみ）",
			"description" => "FTP経由でリモートサイトにデータを送信する際に、一時的に保存しておくためのローカルのディレクトリを指定します。FTPが完了した後、このディレクトリの内容は削除されま。",
			"method" => "dirpath",
			"max_length" => "255"
			),
		"export_hdr_timing" => array(
			"friendly_name" => "タイミングに関する設定",
			"method" => "spacer",
			),
		"export_timing" => array(
			"friendly_name" => "書き出しのタイミング",
			"description" => "Choose when to export graphs.",
			"method" => "drop_array",
			"default" => "disabled",
			"array" => array(
						"disabled" => "無効",
						"classic" => "クラシック (指定された時間ごとに実行する)",
						"export_hourly" => "指定された時間（分）で毎時実行する",
						"export_daily" => "指定された時刻で毎日実行する"
						),
			),
		"path_html_export_skip" => array(
			"friendly_name" => "「指定された時間ごとに実行する」を選択時の設定",
			"description" => "ここを空にした場合は５分ごとに画像の書き出しが行われますが、これよりも長い時間にしたい場合はここに値を指定してください。尚、指定する値は５分に対する倍率となります。<br><br>例.３を指定した場合<br>　５（分）×３（倍）＝１５（分）となります。",
			"method" => "textbox",
			"max_length" => "10",
			"size" => "5"
			),
		"export_hourly" => array(
			"friendly_name" => "「指定された時間（分）で毎時実行する」を選択時の設定",
			"description" => "時間ごとに画像を書き出す場合はここに１時間のうちで実行する時間（分）を指定します。尚、Cactiでは５分ごとにデータ収集を実行することを前提としているため、指定した値が５分ごとの時間に近い値に設定されます。<br><br>例.43を指定した場合<br>　Cactiの前提条件を元に５分ごとに時間を加算していくと４３は４０の次に該当するため４０分で設定されます。",
			"method" => "textbox",
			"max_length" => "10",
			"size" => "5"
			),
		"export_daily" => array(
			"friendly_name" => "「指定された時刻で毎日実行する」を選択時の設定",
			"description" => "日ごとに画像を書き出す場合はここに１日のうちで実行する時間を指定します。尚、Cactiでは５分ごとにデータ収集を実行することを前提としているため、指定した値が５分ごとの時間に近い値に設定されます。<br><br>例.21:23（午後9時23分）を指定した場合<br>　Cactiの前提条件を元に５分ごとに時間を加算していくと21:23（午後9時23分）は21:20（午後9時20分）の次に該当するため21:20で設定されます。",
			"method" => "textbox",
			"max_length" => "10",
			"size" => "5"
			),
		"export_hdr_ftp" => array(
			"friendly_name" => "FTPに関する設定",
			"method" => "spacer",
			),
		"export_ftp_sanitize" => array(
			"friendly_name" => "リモートディレクトリのサニタイズ",
			"description" => "FTPを使って保存先のディレクトリ内に書き出しを行う際に既にファイルが存在する場合それを削除する場合はチェックボックスをオンにします。尚、このオプションはPHPでFTPモジュールが有効になっている場合のみ適用されます。",
			"method" => "checkbox",
			"max_length" => "255"
			),
		"export_ftp_host" => array(
			"friendly_name" => "FTPのホスト",
			"description" => "FTPを使ってグラフをアップロードするホストを指定します。",
			"method" => "textbox",
			"max_length" => "255"
			),
		"export_ftp_port" => array(
			"friendly_name" => "FTPのポート番号",
			"description" => "FTPサーバーの接続ポートを指定します（デフォルトで構わない場合はここを空白にします）<br>デフォルトは\"21\"です。",
			"method" => "textbox",
			"max_length" => "10",
			"size" => "5"
			),
		"export_ftp_passive" => array(
			"friendly_name" => "パッシブモードの有無",
			"description" => "FTPサーバーへの接続をパッシブモードで行う場合はチェックボックスをオンにします。",
			"method" => "checkbox",
			"max_length" => "255"
			),
		"export_ftp_user" => array(
			"friendly_name" => "FTPのユーザー名",
			"description" => "FTP接続時のユーザー名を指定します（デフォルトで構わない場合はここを空白にします）<br>デフォルトは\"Anonymous\"です。",
			"method" => "textbox",
			"max_length" => "255"
			),
		"export_ftp_password" => array(
			"friendly_name" => "FTPのパスワード",
			"description" => "FTP接続時のパスワードを指定します（指定しない場合はここを空白にします）",
			"method" => "textbox_password",
			"max_length" => "255"
			)
		),
	"visual" => array(
		"graphmgmt_header" => array(
			"friendly_name" => "グラフ管理",
			"method" => "spacer",
			),
		"num_rows_graph" => array(
			"friendly_name" => "１ページあたりに表示する行数",
			"description" => "「グラフ管理」のページで１ページあたりに表示する行数を選択します。",
			"method" => "drop_array",
			"default" => "30",
			"array" => $item_rows
			),
		"max_title_graph" => array(
			"friendly_name" => "タイトルの最大文字数",
			"description" => "「グラフ管理」で表示しているタイトルの最大文字数を指定します。<br>タイトルがマルチバイトの場合はここの数値によっては文字化けが起こる可能性があります。",
			"method" => "textbox",
			"default" => "80",
			"max_length" => "10",
			"size" => "5"
			),
		"dataqueries_header" => array(
			"friendly_name" => "データクエリ",
			"method" => "spacer",
			),
		"max_data_query_field_length" => array(
			"friendly_name" => "フィールドの最大文字数",
			"description" => "「データクエリ」で表示しているフィールドの最大文字数を指定します。",
			"method" => "textbox",
			"default" => "15",
			"max_length" => "10",
			"size" => "5"
			),
		"graphs_new_header" => array(
			"friendly_name" => "グラフ作成に関する設定",
			"method" => "spacer",
			),
		"default_graphs_new_dropdown" => array(
			"friendly_name" => "グラフの種類に関するドロップダウンリストのデフォルト設定",
			"description" => "「新規グラフ」ページ内に表示している「グラフの種類」のドロップダウンリストのデフォルト設定を選択します。",
			"method" => "drop_array",
			"default" => "-2",
			"array" => array("-2" => "すべての種類", "-1" => "グラフテンプレート／データクエリ"),
			),
		"num_rows_data_query" => array(
			"friendly_name" => "Data Query Graph Rows",
			"description" => "「新規グラフ」ページにおいてデータクエリを選択している場合、各データクエリごとに表示する最大行数を選択します。",
			"method" => "drop_array",
			"default" => "30",
			"array" => $item_rows
			),
		"datasources_header" => array(
			"friendly_name" => "データソース",
			"method" => "spacer",
			),
		"num_rows_data_source" => array(
			"friendly_name" => "１ページあたりに表示する行数",
			"description" => "「データソース」のページで１ページあたりに表示する行数を選択します。",
			"method" => "drop_array",
			"default" => "30",
			"array" => $item_rows
			),
		"max_title_data_source" => array(
			"friendly_name" => "タイトル幅の最大値",
			"description" => "「データソース」で表示しているタイトルの最大文字数を指定します。<br>タイトルがマルチバイトの場合はここの数値によっては文字化けが起こる可能性があります。",
			"method" => "textbox",
			"default" => "45",
			"max_length" => "10",
			"size" => "5"
			),
		"devices_header" => array(
			"friendly_name" => "デバイス",
			"method" => "spacer",
			),
		"num_rows_device" => array(
			"friendly_name" => "１ページあたりに表示する行数",
			"description" => "「デバイス」のページで１ページあたりに表示する行数を選択します。",
			"method" => "drop_array",
			"default" => "30",
			"array" => $item_rows
			),
		"logmgmt_header" => array(
			"friendly_name" => "ログ管理に関するデフォルト設定",
			"method" => "spacer",
			),
		"num_rows_log" => array(
			"friendly_name" => "ログファイルの表示行数",
			"description" => "「ログファイルの表示」で表示する行数を選択します。",
			"method" => "drop_array",
			"default" => 500,
			"array" => $log_tail_lines,
			),
		"log_refresh_interval" => array(
			"friendly_name" => "ログファイルの更新間隔",
			"description" => "「ログファイルの表示」でページを更新する間隔を選択します。",
			"method" => "drop_array",
			"default" => 60,
			"array" => $page_refresh_interval,
			),
		"fonts_header" => array(
			"friendly_name" => "RRDtool-1.2のフォントに関するデフォルト設定",
			"method" => "spacer",
			),
		"title_size" => array(
			"friendly_name" => "タイトルの文字サイズ",
			"description" => "グラフに表示しているタイトルの文字の大きさを指定します。",
			"method" => "textbox",
			"default" => "10",
			"max_length" => "10",
			"size" => "5"
			),
		"title_font" => array(
			"friendly_name" => "タイトルのフォントファイル",
			"description" => "グラフに表示しているタイトルに利用するフォントを指定します。" . "<br/>" .
							"RRDtoolのバージョンが1.2の場合は、TrueTypeフォントファイルのパスを指定します。" . "<br/><br/>" .
							"RRDtoolのバージョンが1.3以上の場合はPangoの命名規則に従ってください:" . "<br/>" .
							'【Pangoの書式】 [FAMILY-LIST] [STYLE-OPTIONS] [SIZE]<br/>' .
							'"FAMILY-LIST"はフォントを指定します（複数指定はカンマ（,）で区切ります）<br>' .
							'"STYLE_OPTIONS"は文字のスタイルを指定します（複数指定はスペースで区切ります）<br>' .
							'　[スタイルの種類]<br>' .
							'　　style: スタイル（Normal,italic,obliqueのいずれか）<br>' .
							'　　variant: スモールキャピタル(normal,smallcapsのいずれか)<br>' .
							'　　weight: 太さ(ultralightなどの4つのキーワードから１つまたは数値)<br>' .
							'　　stretch: 伸び(ultracondensedなどの9つのキーワードから１つ)<br>' .
							'　　gravity: 縦書きオプション<br>' .
							'"SIZE"は文字のサイズを数値もしくはpx修飾子を使った絶対サイズで指定します。',
			"method" => "font",
			"max_length" => "100"
			),
		"legend_size" => array(
			"friendly_name" => "凡例の文字サイズ",
			"description" => "グラフに表示している凡例の文字の大きさを指定します。",
			"method" => "textbox",
			"default" => "8",
			"max_length" => "10",
			"size" => "5"
			),
		"legend_font" => array(
			"friendly_name" => "凡例のフォントファイル",
			"description" => "グラフに表示している凡例に利用するフォントを指定します。",
			"method" => "font",
			"max_length" => "100"
			),
		"axis_size" => array(
			"friendly_name" => "軸の文字サイズ",
			"description" => "グラフに表示している軸の文字の大きさを指定します。",
			"method" => "textbox",
			"default" => "7",
			"max_length" => "10",
			"size" => "5"
			),
		"axis_font" => array(
			"friendly_name" => "軸のフォントファイル",
			"description" => "グラフに表示している軸に利用するフォントを指定します。",
			"method" => "font",
			"max_length" => "100"
			),
		"unit_size" => array(
			"friendly_name" => "単位の文字サイズ",
			"description" => "グラフに表示している単位の文字の大きさを指定します。",
			"method" => "textbox",
			"default" => "7",
			"max_length" => "10",
			"size" => "5"
			),
		"unit_font" => array(
			"friendly_name" => "単位のフォントファイル",
			"description" => "グラフに表示している単位に利用するフォントを指定します。",
			"method" => "font",
			"max_length" => "100"
			)
		),
	"poller" => array(
		"poller_header" => array(
			"friendly_name" => "一般",
			"method" => "spacer",
			),
		"poller_enabled" => array(
			"friendly_name" => "有効",
			"description" => "ポーリングプロセスを停止したい場合はここのチェックボックスをオフにします。",
			"method" => "checkbox",
			"default" => "on",
			"tab" => "poller"
			),
		"poller_type" => array(
			"friendly_name" => "Pollerの種類",
			"description" => "使用するPollerの種類を選択します。ここの設定を変更した場合は次回のポーリングで有効になります。",
			"method" => "drop_array",
			"default" => 1,
			"array" => $poller_options,
			),
		"poller_interval" => array(
			"friendly_name" => "Pollerの実行間隔",
			"description" => "使用しているポーリングツールの実行間隔を指定します。この設定はRRDファイルを確認してデータを更新する頻度に影響します。<br>
			<strong><u>注）この値を変更した場合はPollerのキャッシュを再構築する必要があります。もしこれを行わない場合、データが失われる可能性があります。また、既に運用している環境においてはStep数パラメータが異なるため、それまでのRRDファイルは使用できなくなりますので変更する場合は注意してください。</u></strong>",
			"method" => "drop_array",
			"default" => 300,
			"array" => $poller_intervals,
			),
		"cron_interval" => array(
			"friendly_name" => "cronの実行間隔",
			"description" => "使用しているcronの実行間隔を選択します。これはサーバー上で稼動しているcronまたはスケジュールされたタスクにおいて実行している間隔を選択してください。",
			"method" => "drop_array",
			"default" => 300,
			"array" => $cron_intervals,
			),
		"concurrent_processes" => array(
			"friendly_name" => "Pollerプロセスの最大同時実行数",
			"description" => "実行する同時プロセス数を指定します。\"cmd.php\"を使用する場合は、大きな数字を指定することでパフォーマンスが向上します。\"spine\"では「プロセスごとの最大スレッド数」パラメータでパフォーマンスの改善を行います。",
			"method" => "textbox",
			"default" => "1",
			"max_length" => "10",
			"size" => "5"
			),
		"process_leveling" => array(
			"friendly_name" => "プロセスの負荷分散",
			"description" => "このオプションを選択した場合、Cactiはポーリングする項目を均等に振り分けることにより、各Pollerプロセスの負荷を分散します。",
			"method" => "checkbox",
			"default" => "on"
			),
		"spine_header" => array(
			"friendly_name" => "Spineのパラメータに関する設定",
			"method" => "spacer",
			),
		"max_threads" => array(
			"friendly_name" => "プロセスごとの最大スレッド数",
			"description" => "プロセスごとに実行する最大スレッド数を指定します。Spineを使用する場合は、大きな数字を指定することでパフォーマンスが向上します。",
			"method" => "textbox",
			"default" => "1",
			"max_length" => "10",
			"size" => "5"
			),
		"php_servers" => array(
			"friendly_name" => "PHPスクリプトサーバの同時実行数",
			"description" => "Spineプロセスごとに実行する同時スクリプトサーバ数を指定します。設定できる値は１から１０になります。いくつかのスレッドとスクリプトサーバーのスクリプトを実行している環境においてはここのパラメータが役立ちます。",
			"method" => "textbox",
			"default" => "1",
			"max_length" => "10",
			"size" => "5"
			),
		"script_timeout" => array(
			"friendly_name" => "スクリプト及びスクリプトサーバのタイムアウト",
			"description" => "Cactiで実行するスクリプトのタイムアウトを指定します（単位：秒）",
			"method" => "textbox",
			"default" => "25",
			"max_length" => "10",
			"size" => "5"
			),
		"max_get_size" => array(
			"friendly_name" => "SNMPリクエストあたりのSNMPの最大OID数",
			"description" => "snmpbulkwalkでリクエストごとに取得するSNMPのOIDの最大数を指定します。この値を増やすと低速接続時におけるPollerのパフォーマンスを高速化することが出来ます。指定できる最大値は100で、０または１よりも小さい値を指定するとsnmpbulkwalkは無効になります。",
			"method" => "textbox",
			"default" => "10",
			"max_length" => "10",
			"size" => "5"
			),
		"availability_header" => array(
			"friendly_name" => "ホストの稼動状況に関する設定",
			"method" => "spacer",
			),
		"availability_method" => array(
			"friendly_name" => "ホストのダウン状態の検出",
			"description" => "ポーリングによるホストの稼動状態を判断する方法を選択します。<br><i>注）最低限、SNMPは選択しておくことを推奨します。</i>",
			"method" => "drop_array",
			"default" => AVAIL_SNMP,
			"array" => $availability_options,
			),
		"ping_method" => array(
			"friendly_name" => "Pingの種類",
			"description" => "送信するPingのパケットの種類を選択します。<br><i>注）LinuxまたはUNIXでICMPを利用する場合はルート権限が必要になります。</i>",
			"method" => "drop_array",
			"default" => PING_UDP,
			"array" => $ping_methods,
			),
		"ping_port" => array(
			"friendly_name" => "Pingのポート番号",
			"description" => "接続するTCPまたはUDPのポート番号を指定します。",
			"method" => "textbox",
			"default" => "23",
			"max_length" => "10",
			"size" => "5"
			),
		"ping_timeout" => array(
			"friendly_name" => "Pingのタイムアウト",
			"description" => "ICMPとUDPによるPingを使ったときの応答の待ち時間（ミリ秒）を指定します。SNMPによるPingの場合はSNMPに対するタイムアウトの時間になります。",
			"method" => "textbox",
			"default" => "400",
			"max_length" => "10",
			"size" => "5"
			),
		"ping_retries" => array(
			"friendly_name" => "Pingの再試行回数",
			"description" => "失敗したときに再度Pingを行う回数を指定します。この回数を超えるとエラーとなります。",
			"method" => "textbox",
			"default" => "1",
			"max_length" => "10",
			"size" => "5"
			),
		"updown_header" => array(
			"friendly_name" => "ホストのアップ／ダウンに関する設定",
			"method" => "spacer",
			),
		"ping_failure_count" => array(
			"friendly_name" => "ダウン状態までのポーリング回数",
			"description" => "ホストがダウンしていると判断してログに記録するまでのポーリングの回数を指定します。ここに指定した回数ダウン状態が続いた場合にホストがダウンしていると判断します。",
			"method" => "textbox",
			"default" => "2",
			"max_length" => "10",
			"size" => "5"
			),
		"ping_recovery_count" => array(
			"friendly_name" => "アップ状態までのポーリング回数",
			"description" => "ホストがアップしていると判断して通知するまでのポーリングの回数を指定します。ここに指定した回数アップ状態が続いた場合にホストがアップしていると判断します。",
			"method" => "textbox",
			"default" => "3",
			"max_length" => "10",
			"size" => "5"
			)
		),
	"authentication" => array(
		"general_header" => array(
			"friendly_name" => "一般",
			"method" => "spacer",
			),
		"auth_method" => array(
			"friendly_name" => "認証方法",
			"description" => "<blockquote><i>「なし」</i>　これを選択した場合は認証を使用しないため、すべてのユーザーがフルアクセスできるようになります。<br><br><i>「組み込み認証」</i>　Cacti内に組み込まれた認証機構を利用してユーザーの作成や領域へのアクセス権限の設定を行います。<br><br><i>「Web Basic認証」</i>　Webサーバー側の認証機構を利用します。ユーザーが予めWebサーバー側で定義されている場合、初回ログイン時に自動的に追加または作成され、そうでない場合はゲストのアクセス権限が適用されます。<br><br><i>「LDAP認証」</i>　LDAPサーバーを利用した認証を行います。ユーザーが予めLDAPサーバー側で定義されている場合、初回ログイン時に自動的に追加または作成され、そうでない場合はゲストのアクセス権限が適用されます。尚、PHPでLDAPモジュールが有効になっていない場合はこの認証は一覧の中には表示されません。</blockquote>",
			"method" => "drop_array",
			"default" => 1,
			"array" => $auth_methods
			),
		"special_users_header" => array(
			"friendly_name" => "スペシャルユーザーに関する設定",
			"method" => "spacer",
			),
		"guest_user" => array(
			"friendly_name" => "ゲストユーザー",
			"description" => "グラフを表示するためのゲスト用ユーザーを選択します（デフォルトは\"なし\"）",
			"method" => "drop_sql",
			"none_value" => "なし",
			"sql" => "select username as id, username as name from user_auth where realm = 0 order by username",
			"default" => "0"
			),
		"user_template" => array(
			"friendly_name" => "テンプレートのユーザー",
			"description" => "WebBasic認証及びLDAP認証で新しいユーザーとして追加するためのテンプレートとして使用するユーザーを選択します（デフォルトは\"guest\"）",
			"method" => "drop_sql",
			"none_value" => "なし",
			"sql" => "select username as id, username as name from user_auth where realm = 0 order by username",
			"default" => "0"
			),
		"ldap_general_header" => array(
			"friendly_name" => "LDAPに関する設定",
			"method" => "spacer"
			),
		"ldap_server" => array(
			"friendly_name" => "サーバー名",
			"description" => "LDAPサーバーのホスト名またはIPアドレスを指定します。",
			"method" => "textbox",
			"max_length" => "255"
			),
		"ldap_port" => array(
			"friendly_name" => "非SSLのポート番号",
			"description" => "非SSLのポート番号を指定します。",
			"method" => "textbox",
			"max_length" => "5",
			"default" => "389",
			"size" => "5"
			),
		"ldap_port_ssl" => array(
			"friendly_name" => "SSLのポート番号",
			"description" => "SSLのポート番号を指定します。",
			"method" => "textbox",
			"max_length" => "5",
			"default" => "636",
			"size" => "5"
			),
		"ldap_version" => array(
			"friendly_name" => "プロトコルバージョン",
			"description" => "サーバーがサポートしているプロトコルバージョンを選択します。",
			"method" => "drop_array",
			"default" => "3",
			"array" => $ldap_versions
			),
		"ldap_encryption" => array(
			"friendly_name" => "暗号方式",
			"description" => "サーバーがサポートしている暗号方式を選択します。TLSはプロトコルバージョン３でのみサポートされています。",
			"method" => "drop_array",
			"default" => "0",
			"array" => $ldap_encryption
			),
		"ldap_referrals" => array(
			"friendly_name" => "リフェラル(Referral)機能の有無",
			"description" => "LDAPのりフェラル機能の有効／無効を選択します。もし無効にした場合は検索速度を高められる可能性があります。",
			"method" => "drop_array",
			"default" => "0",
			"array" => array( "0" => "無効", "1" => "有効")
			),
		"ldap_mode" => array(
			"friendly_name" => "モード",
		"description" => "LDAPサーバーに対して認証を試みる際のモードを選択します。<blockquote><i>「検索しない」</i>　識別名（DN：Distinguished Name）での検索を行わずに、提供された識別名（DN：Distinguished Name）形式で行います。<br><br><i>「匿名検索」</i>　ユーザー識別名（DN）を見つけるために匿名をバインドしてLDAPディレクトリに対してユーザー名の検索を行います。<br><br><i>「特定検索」</i>　ユーザー識別名（DN）を見つけるためにバインドする識別名（DN）と固有のパスワードを利用してLDAPディレクトリに対してユーザー名の検索を行います。",
			"method" => "drop_array",
			"default" => "0",
			"array" => $ldap_modes
			),
		"ldap_dn" => array(
			"friendly_name" => "識別名（DN：Distinguished Name）",
			"description" => "Windowsでの識別名の構文は「<i>\"&lt;ユーザー名&gt;@win2kdomain.local\"</i>」になり、OpenLDAPでは「<i>\"uid=&lt;ユーザー名&gt;,ou=people,dc=domain,dc=local\"</i>」となります。モードの選択で「検索しない」を選択した場合のみ使用します。",
			"method" => "textbox",
			"max_length" => "255"
			),
		"ldap_group_require" => array(
			"friendly_name" => "グループメンバーシップの使用",
			"description" => "ユーザーが認証するためにグループのメンバーである必要があります。これを有効にする場合にはグループの設定を行っておく必要があります。もし、適切なグループ設定が行われずに有効にした場合は、認証が失敗する原因になります。",
			"default" => "",
			"method" => "checkbox"
			),
		"ldap_group_header" => array(
			"friendly_name" => "LDAPのグループに関する設定",
			"method" => "spacer"
			),
		"ldap_group_dn" => array(
			"friendly_name" => "グループの識別名（DN：Distinguished Name）",
			"description" => "ユーザーが持つメンバーシップのグループ識別名を指定します。",
			"method" => "textbox",
			"max_length" => "255"
			),
		"ldap_group_attrib" => array(
			"friendly_name" => "グループメンバーの属性",
			"description" => "メンバーのユーザー名を含む属性の名前を指定します。",
			"method" => "textbox",
			"max_length" => "255"
			),
		"ldap_group_member_type" => array(
			"friendly_name" => "グループメンバーの種類",
			"description" => "定義したグループメンバーの属性で「識別名（DN）」または「ユーザー名」のどちらで使用するかを選択します。",
			"method" => "drop_array",
			"default" => 1,
			"array" => array( 1 => "識別名（DN）", 2 => "ユーザー名" )
			),
		"ldap_search_base_header" => array(
			"friendly_name" => "LDAPの検索に関する設定",
			"method" => "spacer"
			),
		"ldap_search_base" => array(
			"friendly_name" => "検索ベース",
			"description" => "LDAPディレクトで検索を行うための検索のベース（基本）を指定します。書式は「<i>\"dc=win2kdomain,dc=local\"</i>」または「<i>\"ou=people,dc=domain,dc=local\"</i>」です。",
			"method" => "textbox",
			"max_length" => "255"
			),
		"ldap_search_filter" => array(
			"friendly_name" => "検索フィルタ",
			"description" => "LDAPディレクトリでユーザーを検索するために使用する検索フィルタを指定します。Windowsでは「<i>\"(&amp;(objectclass=user)(objectcategory=user)(userPrincipalName=&lt;ユーザー名&gt;*))\"</i>」となり、OpenLDAPでは「<i>\"(&(objectClass=account)(uid=&lt;ユーザー名&gt))\"</i>となります。",
			"method" => "textbox",
			"max_length" => "255"
			),
		"ldap_specific_dn" => array(
			"friendly_name" => "検索識別名（DN）",
			"description" => "LDAPディレクトリにバインドする検索のための識別名を指定します。",
			"method" => "textbox",
			"max_length" => "255"
			),
		"ldap_specific_password" => array(
			"friendly_name" => "検索パスワード",
			"description" => "LDAPディレクトリにバインドする検索のためのパスワードを指定します（確認も含めて２回入力します）",
			"method" => "textbox_password",
			"max_length" => "255"
			)
		)
	);

$settings_graphs = array(
	"general" => array(
		"default_rra_id" => array(
			"friendly_name" => "ラウンドロビンアーカイブ（RRA）のデフォルト設定",
			"description" => "「サムネイルのタイムスパン」が0に設定された時またはサムネイル表示をしていないときに使用するラウンドロビンアーカイブを選択します。",
			"method" => "drop_sql",
			"sql" => "select id,name from rra order by timespan",
			"default" => "1"
			),
		"default_view_mode" => array(
			"friendly_name" => "表示モードのデフォルト設定",
			"description" => "「グラフ」タブを選択したときのページの表示モードを選択します。",
			"method" => "drop_array",
			"array" => $graph_views,
			"default" => "1"
			),
		"default_timespan" => array(
			"friendly_name" => "グラフ表示におけるタイムスパンのデフォルト設定",
			"description" => "表示するグラフのタイムスパンを選択します。",
			"method" => "drop_array",
			"array" => $graph_timespans,
			"default" => GT_LAST_DAY
			),
		"timespan_sel" => array(
			"friendly_name" => "タイムスパン選択リストの表示",
			"description" => "タイムスパンを選択するリストボックスを表示する場合はチェックボックスをオンにします。",
			"method" => "checkbox",
			"default" => "on"
		),
		"default_timeshift" => array(
			"friendly_name" => "グラフ表示におけるタイムシフトのデフォルト設定",
			"description" => "表示するグラフのタイムシフトを選択します。",
			"method" => "drop_array",
			"array" => $graph_timeshifts,
			"default" => GTS_1_DAY
			),
		"allow_graph_dates_in_future" => array(
			"friendly_name" => "現在の時刻より先へグラフの表示を拡張",
			"description" => "グラフを表示するときに現在の時刻よりも先の未来へ日付を拡張出来るようにする場合はチェックボックスをオンにします。",
			"method" => "checkbox",
			"default" => "on"
		),
		"first_weekdayid" => array(
			"friendly_name" => "週の最初とする曜日",
			"description" => "毎週のグラフ表示において、週の最初とする曜日を選択します。",
			"method" => "drop_array",
			"array" => $graph_weekdays,
			"default" => WD_MONDAY
			),
		"day_shift_start" => array(
			"friendly_name" => "１日シフトの開始時間",
			"description" => "１日シフトを行う際の開始時間を指定します。",
			"method" => "textbox",
			"default" => "07:00",
			"max_length" => "5"
			),
		"day_shift_end" => array(
			"friendly_name" => "１日シフトの終了時間",
			"description" => "１日シフトを行う際の終了時間を指定します。",
			"method" => "textbox",
			"default" => "18:00",
			"max_length" => "5"
			),
		"default_date_format" => array(
			"friendly_name" => "グラフに表示する日付の形式",
			"description" => "グラフに表示する日付の形式を選択します。",
			"method" => "drop_array",
			"array" => $graph_dateformats,
			"default" => GD_Y_MO_D
			),
		"default_datechar" => array(
			"friendly_name" => "日付の区切り文字",
			"description" => "日付の区切り文字を選択します。",
			"method" => "drop_array",
			"array" => $graph_datechar,
			"default" => GDC_SLASH
			),
		"page_refresh" => array(
			"friendly_name" => "ページの更新時間",
			"description" => "自動的にページを更新する間隔を指定します（単位：秒）",
			"method" => "textbox",
			"default" => "300",
			"max_length" => "10"
			)
		),
	"thumbnail" => array(
		"default_height" => array(
			"friendly_name" => "サムネイルの高さ",
			"description" => "サムネイル表示するグラフの高さを指定します（単位: ピクセル）",
			"method" => "textbox",
			"default" => "100",
			"max_length" => "10"
			),
		"default_width" => array(
			"friendly_name" => "サムネイルの幅",
			"description" => "サムネイル表示するグラフの幅を指定します（単位: ピクセル）",
			"method" => "textbox",
			"default" => "300",
			"max_length" => "10"
			),
		"num_columns" => array(
			"friendly_name" => "サムネイルの列",
			"description" => "グラフをサムネイルで表示する場合の１行あたりの列数（横に並べる数）を指定します。",
			"method" => "textbox",
			"default" => "2",
			"max_length" => "5"
			),
		"thumbnail_sections" => array(
			"friendly_name" => "サムネイル表示するセクション",
			"description" => "サムネイル表示を行うセクションを選択します。",
			"method" => "checkbox_group",
			"items" => array(
				"thumbnail_section_preview" => array(
					"friendly_name" => "プレビューモード",
					"default" => "on"
					),
				"thumbnail_section_tree_1" => array(
					"friendly_name" => "ツリー表示（シングルペイン）",
					"default" => "on"
					),
				"thumbnail_section_tree_2" => array(
					"friendly_name" => "ツリー表示（デュアルペイン）",
					"default" => ""
					)
				)
			)
		),
	"tree" => array(
		"default_tree_id" => array(
			"friendly_name" => "グラフツリーのデフォルト設定",
			"description" => "ツリーモードでグラフを表示するときに最初に表示するツリーを選択します。",
			"method" => "drop_sql",
			"sql" => "select id,name from graph_tree order by name",
			"default" => "0"
			),
		"default_tree_view_mode" => array(
			"friendly_name" => "ツリー表示モードのデフォルト設定",
			"description" => "ツリーモードで表示するときに使用するモードを選択します。",
			"method" => "drop_array",
			"array" => $graph_tree_views,
			"default" => "2"
			),
		"treeview_graphs_per_page" => array(
			"friendly_name" => "ページごとのグラフ数",
			"description" => "プレビューモードで１ページに表示するグラフの数を選択します。",
			"method" => "drop_array",
			"default" => "10",
			"array" => $graphs_per_page
			),
		"default_dual_pane_width" => array(
			"friendly_name" => "デュアルペイン時のツリーの表示枠の幅",
			"description" => "デュアルペインのツリー表示を選択した場合にツリーを表示している枠の幅を指定します（単位：ピクセル）",
			"method" => "textbox",
			"max_length" => "5",
			"default" => "200"
			),
		"expand_hosts" => array(
			"friendly_name" => "ホストを展開",
			"description" => "デュアルペインでホストに登録しているグラフテンプレートをツリーのホストの下に一覧表示する場合はここのチェックボックスをオンにします。",
			"method" => "checkbox",
			"default" => ""
			),
		"show_graph_title" => array(
			"friendly_name" => "グラフのタイトルを表示",
			"description" => "ブラウザで検索を使ってグラフを探せるようにページ上にグラフのタイトルを表示する場合はここのチェックボックスをオンにします。",
			"method" => "checkbox",
			"default" => ""
			)
		),
	"preview" => array(
		"preview_graphs_per_page" => array(
			"friendly_name" => "１ページあたりのグラフ数",
			"description" => "プレビュー表示において１ページあたりに表示するグラフの数を選択します。",
			"method" => "drop_array",
			"default" => "10",
			"array" => $graphs_per_page
			)
		),
	"list" => array(
		"list_graphs_per_page" => array(
			"friendly_name" => "１ページあたりのグラフ数",
			"description" => "リスト表示において１ページあたりに表示するグラフの数を選択します。",
			"method" => "drop_array",
			"default" => "30",
			"array" => $graphs_per_page
			)
		),
	"fonts" => array(
		"custom_fonts" => array(
			"friendly_name" => "フォントのカスタム設定",
			"description" => "デフォルトで設定されているフォントとは別のフォントを利用したい場合はここのチェックボックスをオンにして設定を行います。",
			"method" => "checkbox",
			"on_change" => "graphSettings()",
			"default" => ""
			),
		"title_size" => array(
			"friendly_name" => "タイトルの文字サイズ",
			"description" => "グラフに表示しているタイトルの文字の大きさを指定します。",
			"method" => "textbox",
			"default" => "12",
			"max_length" => "10"
			),
		"title_font" => array(
			"friendly_name" => "タイトルのフォントファイル",
			"description" => "グラフに表示しているタイトルに利用するフォントを指定します。",
			"method" => "font",
			"max_length" => "100"
			),
		"legend_size" => array(
			"friendly_name" => "凡例の文字サイズ",
			"description" => "グラフに表示している凡例の文字の大きさを指定します。",
			"method" => "textbox",
			"default" => "10",
			"max_length" => "10"
			),
		"legend_font" => array(
			"friendly_name" => "凡例のフォントファイル",
			"description" => "グラフに表示している凡例に利用するフォントを指定します。",
			"method" => "font",
			"max_length" => "100"
			),
		"axis_size" => array(
			"friendly_name" => "軸の文字サイズ",
			"description" => "グラフに表示している軸の文字の大きさを指定します。",
			"method" => "textbox",
			"default" => "8",
			"max_length" => "10"
			),
		"axis_font" => array(
			"friendly_name" => "軸のフォントファイル",
			"description" => "グラフに表示している軸に利用するフォントを指定します。",
			"method" => "font",
			"max_length" => "100"
			),
		"unit_size" => array(
			"friendly_name" => "単位の文字サイズ",
			"description" => "グラフに表示している単位の文字の大きさを指定します。",
			"method" => "textbox",
			"default" => "8",
			"max_length" => "10"
			),
		"unit_font" => array(
			"friendly_name" => "単位のフォントファイル",
			"description" => "グラフに表示している単位に利用するフォントを指定します。",
			"method" => "font",
			"max_length" => "100"
			)
		)
	);

?>
