<?php
/*
 +-------------------------------------------------------------------------+
 | Copyright (C) 2004-2012 The Cacti Group                                 |
 |                                                                         |
 | This program is free software; you can redistribute it and/or           |
 | modify it under the terms of the GNU General Public License             |
 | as published by the Free Software Foundation; either version 2          |
 | of the License, or (at your option) any later version.                  |
 |                                                                         |
 | This program is distributed in the hope that it will be useful,         |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of          |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           |
 | GNU General Public License for more details.                            |
 +-------------------------------------------------------------------------+
 | Cacti: The Complete RRDTool-based Graphing Solution                     |
 +-------------------------------------------------------------------------+
 | This code is designed, written, and maintained by the Cacti Group. See  |
 | about.php and/or the AUTHORS file for specific developer information.   |
 +-------------------------------------------------------------------------+
 | http://www.cacti.net/                                                   |
 +-------------------------------------------------------------------------+
*/

global $menu;

$messages = array(
	1  => array(
		"message" => '保存しました。',
		"type" => "info"),
	2  => array(
		"message" => '保存出来ませんでした。',
		"type" => "error"),
	3  => array(
		"message" => '保存できませんでした: 項目に誤りがあります（赤枠で囲まれた項目を確認してください）',
		"type" => "error"),
	4  => array(
		"message" => 'パスワードが一致しません。もう一度入力してください。',
		"type" => "error"),
	5  => array(
		"message" => '最低、項目を１つ選択してください。',
		"type" => "error"),
	6  => array(
		"message" => 'この機能を使うためにはユーザー認証が行えるように変更しなければなりません。',
		"type" => "error"),
	7  => array(
		"message" => 'XML の解析エラーです。',
		"type" => "error"),
	12 => array(
		"message" => 'ユーザー名は既に使用されています。',
		"type" => "error"),
	15 => array(
		"message" => 'XML: Cactiバージョンが存在しません。',
		"type" => "error"),
	16 => array(
		"message" => 'XML: ハッシュバージョンが存在しません。',
		"type" => "error"),
	17 => array(
		"message" => 'XML: 新しいCactiのバージョンで生成されています。',
		"type" => "error"),
	18 => array(
		"message" => 'XML: コードの種類を見つけることが出来ませんでした。',
		"type" => "error"),
	19 => array(
		"message" => 'ユーザー名は既に使用されています。',
		"type" => "error"),
	20 => array(
		"message" => 'テンプレートまたはゲストユーザーに対するユーザー名の変更権限がありません。',
		"type" => "error"),
	21 => array(
		"message" => 'テンプレートまたはゲストユーザーに対するユーザーの削除権限がありません。',
		"type" => "error"),
	22 => array(
		"message" => 'グラフエクスポートユーザーに対するユーザーの削除権限がありません。',
		"type" => "error"),
	23 => array(
		"message" => '削除したラウンドロビンアーカイブにデータテンプレートが含まれています。確認または修正する場合にはデータベースの修復スクリプトを実行してください。',
		"type" => "error"),
	24 => array(
		"message" => '削除したGPRINTプレフィックスにグラフテンプレートが含まれています。確認または修正する場合にはデータベースの修復スクリプトを実行してください。',
		"type" => "error"),
	25 => array(
		"message" => '削除したCDEFにグラフテンプレートが含まれています。確認または修正する場合にはデータベースの修復スクリプトを実行してください。',
		"type" => "error"),
	26 => array(
		"message" => '削除したデータ入力メソッドにグラフテンプレートが含まれています。確認または修正する場合にはデータベースの修復スクリプトを実行してください。',
		"type" => "error"),
	27 => array(
		"message" => 'エクスポートする中にデータテンプレートは見つかりませんでした。確認または修正する場合にはデータベースの修復スクリプトを実行してください。',
		"type" => "error"),
	28 => array(
		"message" => 'エクスポートする中にホストテンプレートは見つかりませんでした。確認または修正する場合にはデータベースの修復スクリプトを実行してください。',
		"type" => "error"),
	29 => array(
		"message" => 'エクスポートする中にデータクエリは見つかりませんでした。確認または修正する場合にはデータベースの修復スクリプトを実行してください。',
		"type" => "error"),
	30 => array(
		"message" => 'エクスポートする中にグラフテンプレートは見つかりませんでした。確認または修正する場合にはデータベースの修復スクリプトを実行してください。',
		"type" => "error"),
	);

$cdef_operators = array(1 =>
	"+",
	"-",
	"*",
	"/",
	"%");

$cdef_functions = array(1 =>
	"SIN",
	"COS",
	"LOG",
	"EXP",
	"FLOOR",
	"CEIL",
	"LT",
	"LE",
	"GT",
	"GE",
	"EQ",
	"IF",
	"MIN",
	"MAX",
	"LIMIT",
	"DUP",
	"EXC",
	"POP",
	"UN",
	"UNKN",
	"PREV",
	"INF",
	"NEGINF",
	"NOW",
	"TIME",
	"LTIME");

$input_types = array(
	DATA_INPUT_TYPE_SNMP => "SNMP", // Action 0:
	DATA_INPUT_TYPE_SNMP_QUERY => "SNMPクエリ",
	DATA_INPUT_TYPE_SCRIPT => "スクリプト／コマンド",  // Action 1:
	DATA_INPUT_TYPE_SCRIPT_QUERY => "クエリ・スクリプト", // Action 1:
	DATA_INPUT_TYPE_PHP_SCRIPT_SERVER => "スクリプト - サーバー・スクリプト（PHP）",
	DATA_INPUT_TYPE_QUERY_SCRIPT_SERVER => "クエリ・スクリプト - サーバー・スクリプト"
	);

$reindex_types = array(
	DATA_QUERY_AUTOINDEX_NONE => "なし",
	DATA_QUERY_AUTOINDEX_BACKWARDS_UPTIME => "Uptimeの値が少なくなっている場合",
	DATA_QUERY_AUTOINDEX_INDEX_NUM_CHANGE => "インデックスの回数が変更されている場合",
	DATA_QUERY_AUTOINDEX_FIELD_VERIFICATION => "すべてのフィールドを照合"
	);

$snmp_query_field_actions = array(1 =>
	"SNMP フィールド名(ドロップダウン)",
	"SNMP フィールド値 (From User)",
	"SNMP 出力の種類 (ドロップダウン)");

$consolidation_functions = array(1 =>
	"AVERAGE",
	"MIN",
	"MAX",
	"LAST");

$data_source_types = array(1 =>
	"GAUGE",
	"COUNTER",
	"DERIVE",
	"ABSOLUTE");

$graph_item_types = array(
	GRAPH_ITEM_TYPE_COMMENT => "COMMENT",
	GRAPH_ITEM_TYPE_HRULE   => "HRULE",
	GRAPH_ITEM_TYPE_VRULE   => "VRULE",
	GRAPH_ITEM_TYPE_LINE1   => "LINE1",
	GRAPH_ITEM_TYPE_LINE2   => "LINE2",
	GRAPH_ITEM_TYPE_LINE3   => "LINE3",
	GRAPH_ITEM_TYPE_AREA    => "AREA",
	GRAPH_ITEM_TYPE_STACK   => "STACK",
	GRAPH_ITEM_TYPE_GPRINT  => "GPRINT",
	GRAPH_ITEM_TYPE_LEGEND  => "LEGEND"
	);

$image_types = array(1 =>
	"PNG",
	"GIF",
	"SVG");

$snmp_versions = array(0 =>
	"SNMP を使用しない",
	"バージョン 1",
	"バージョン 2",
	"バージョン 3");

$snmp_auth_protocols = array(
	"MD5" => "MD5 (デフォルト)",
	"SHA" => "SHA");

$snmp_priv_protocols = array(
	"[None]" => "[なし]",
	"DES" => "DES (デフォルト)",
	"AES128" => "AES");

$banned_snmp_strings = array(
	"End of MIB",
	"No Such");

$logfile_options = array(1 =>
	"ログファイルのみ",
	"ログファイルとSyslog／イベントログ",
	"Syslog／イベントログのみ");

$availability_options = array(
	AVAIL_NONE => "なし",
	AVAIL_SNMP_AND_PING => "PingとSNMP Uptime",
	AVAIL_SNMP_OR_PING => "PingまたはSNMP Uptime",
	AVAIL_SNMP => "SNMP Uptimeのみ",
	AVAIL_SNMP_GET_SYSDESC => "SNMP Desc",
	AVAIL_SNMP_GET_NEXT => "SNMP getNext",
	AVAIL_PING => "Pingのみ");

$ping_methods = array(
	PING_ICMP => "ICMP Ping",
	PING_TCP => "TCP Ping",
	PING_UDP => "UDP Ping");

$logfile_verbosity = array(
	POLLER_VERBOSITY_NONE => "なし - Syslogのみ",
	POLLER_VERBOSITY_LOW => "低レベル - 「統計値」と「エラー」",
	POLLER_VERBOSITY_MEDIUM => "中レベル - 低レベルの設定値＋「結果」",
	POLLER_VERBOSITY_HIGH => "高レベル - 中レベルの設定値＋「主なI/Oイベント」",
	POLLER_VERBOSITY_DEBUG => "デバッグ - 高レベルの設定値＋「プログラムの流れ」",
	POLLER_VERBOSITY_DEVDBG => "開発用デバッグ - 開発用デバッグレベル");

$poller_options = array(1 =>
	"cmd.php",
	"spine");

$poller_intervals = array(
	10 => "10秒毎",
	15 => "15秒毎",
	20 => "20秒毎",
	30 => "30秒毎",
	60 => "1分毎",
	300 => "5分毎");

$device_threads = array(
	1 => "1スレッド (デフォルト)",
	2 => "2スレッド",
	3 => "3スレッド",
	4 => "4スレッド",
	5 => "5スレッド",
	6 => "6スレッド"
	);

$cron_intervals = array(
	60 => "1分毎",
	300 => "5分毎");

$registered_cacti_names = array(
	"path_cacti");

$graph_views = array(1 =>
	"ツリー表示",
	"リスト表示",
	"プレビュー表示");

$graph_tree_views = array(1 =>
	"シングルペイン",
//	"Single Pane",
	"デュアルペイン");
//	"Dual Pane");

$auth_methods = array(
	0 => "なし",
	1 => "組み込み認証",
	2 => "Web Basic 認証");
if (function_exists("ldap_connect")) {
	$auth_methods[3] = "LDAP認証";
}

$auth_realms = array(0 =>
	"Local",
	"LDAP",
	"Web Basic");

$ldap_versions = array(
	2 => "バージョン 2",
	3 => "バージョン 3"
	);

$ldap_encryption = array(
	0 => "なし",
	1 => "SSL",
	2 => "TLS");

$ldap_modes = array(
	0 => "検索しない",
	1 => "匿名ユーザーで検索",
	2 => "特定のユーザーで検索");

$snmp_implimentations = array(
	"ucd-snmp" => "UCD-SNMP 4.x",
	"net-snmp" => "NET-SNMP 5.x");

$rrdtool_versions = array(
	"rrd-1.0.x" => "RRDTool 1.0.x",
	"rrd-1.2.x" => "RRDTool 1.2.x",
	"rrd-1.3.x" => "RRDTool 1.3.x",
	"rrd-1.4.x" => "RRDTool 1.4.x");

$cdef_item_types = array(
	1 => "関数",
	2 => "演算子",
	4 => "データソース",
	5 => "別の CDEF",
	6 => "文字列");

$graph_color_alpha = array(
		"00" => "  0%",
		"19" => " 10%",
		"33" => " 20%",
		"4C" => " 30%",
		"66" => " 40%",
		"7F" => " 50%",
		"99" => " 60%",
		"B2" => " 70%",
		"CC" => " 80%",
		"E5" => " 90%",
		"FF" => "100%"
		);

$tree_sort_types = array(
	TREE_ORDERING_NONE => "手動整列 (ソートしません)",
	TREE_ORDERING_ALPHABETIC => "アルファベット順",
	TREE_ORDERING_NATURAL => "登録順",
	TREE_ORDERING_NUMERIC => "数字順"
	);

$tree_item_types = array(
	TREE_ITEM_TYPE_HEADER => "ヘッダー",
	TREE_ITEM_TYPE_GRAPH => "グラフ",
	TREE_ITEM_TYPE_HOST => "ホスト"
	);

$host_group_types = array(
	HOST_GROUPING_GRAPH_TEMPLATE => "グラフのテンプレート",
	HOST_GROUPING_DATA_QUERY_INDEX => "データ照会名"
	);

$custom_data_source_types = array(
	"CURRENT_DATA_SOURCE" => "現在のグラフ項目のデータソース",
	"ALL_DATA_SOURCES_NODUPS" => "すべてのデータソース(複製を含まない)",
	"ALL_DATA_SOURCES_DUPS"	=> "すべてのデータソース(複製を含む)",
	"SIMILAR_DATA_SOURCES_NODUPS" => "すべての類似するデータソース(複製を含まない)",
	"SIMILAR_DATA_SOURCES_DUPS" => "すべての類似するデータソース(複製を含む)",
	"CURRENT_DS_MINIMUM_VALUE" => "現在のデータソース項目: 最小値",
	"CURRENT_DS_MAXIMUM_VALUE" => "現在のデータソース項目: 最大値",
	"CURRENT_GRAPH_MINIMUM_VALUE" => "グラフ: 下限",
	"CURRENT_GRAPH_MAXIMUM_VALUE" => "グラフ: 上限",
	"COUNT_ALL_DS_NODUPS" => "すべてのデータソースの数(複製を含まない)",
	"COUNT_ALL_DS_DUPS" => "すべてのデータソースの数(複製を含む)",
	"COUNT_SIMILAR_DS_NODUPS" => "すべての類似するデータソースの数(複製を含まない)",
	"COUNT_SIMILAR_DS_DUPS"	=> "すべての類似するデータソースの数(複製を含む)");

$menu = array(
	"作成" => array(
		"graphs_new.php" => "新規グラフ"
		),
	"管理" => array(
		"graphs.php" => array(
			"graphs.php" => "グラフ管理",
			"cdef.php" => "CDEFs",
			"color.php" => "色",
			"gprint_presets.php" => "GPRINT プリセット"
			),
		"tree.php" => "グラフツリー",
		"data_sources.php" => array(
			"data_sources.php" => "データソース",
			"rra.php" => "RRAs"
			),
		"host.php" => 'デバイス'
		),
	"入力方法" => array(
		"data_queries.php" => "データクエリ",
		"data_input.php" => "データ入力メソッド"
		),
	"テンプレート" => array(
		"graph_templates.php" => "グラフテンプレート",
		"host_templates.php" => "ホストテンプレート",
		"data_templates.php" => "データテンプレート"
		),
	"インポート／エクスポート" => array(
		"templates_import.php" => "テンプレートインポート",
		"templates_export.php" => "テンプレートエクスポート"
		),
	"設定"  => array(
		"settings.php" => "設定"
		),
	"ユーティリティ" => array(
		"utilities.php" => "システムユーティリティ",
		"user_admin.php" => "ユーザー管理",
		"logout.php" => "ユーザーログアウト"
	));

$log_tail_lines = array(
	-1 => "すべて",
	10 => "10行",
	15 => "15行",
	20 => "20行",
	50 => "50行",
	100 => "100行",
	200 => "200行",
	500 => "500行",
	1000 => "1000行",
	2000 => "2000行",
	3000 => "3000行",
	5000 => "5000行",
	10000 => "10000行"
	);

$item_rows = array(
	10 => "10",
	15 => "15",
	20 => "20",
	25 => "25",
	30 => "30",
	40 => "40",
	50 => "50",
	100 => "100",
	250 => "250",
	500 => "500",
	1000 => "1000",
	2000 => "2000",
	5000 => "5000"
	);

$graphs_per_page = array(
	4 => "4",
	6 => "6",
	8 => "8",
	10 => "10",
	14 => "14",
	20 => "20",
	24 => "24",
	30 => "30",
	40 => "40",
	50 => "50",
	100 => "100"
	);

$page_refresh_interval = array(
	5 => "5秒",
	10 => "10秒",
	20 => "20秒",
	30 => "30秒",
	60 => "1分",
	300 => "5分",
	600 => "10分",
	9999999 => "行わない");

$user_auth_realms = array(
	1 => "ユーザー管理",
	2 => "データ入力",
	3 => "データソースの更新",
	4 => "グラフツリーの更新",
	5 => "グラフの更新",
	7 => "グラフの表示",
	8 => "コンソールへのアクセス",
	9 => "ラウンドロビンアーカイブ（RRA）の更新",
	10 => "グラフテンプレートの更新",
	11 => "データテンプレートの更新",
	12 => "ホストテンプレートの更新",
	13 => "データクエリ",
	14 => "CDEFの更新",
	15 => "グラフの設定",
	16 => "データのエクスポート",
	17 => "データのインポート"
	);

$user_auth_realm_filenames = array(
	"about.php" => 8,
	"cdef.php" => 14,
	"color.php" => 5,
	"data_input.php" => 2,
	"data_sources.php" => 3,
	"data_templates.php" => 11,
	"gprint_presets.php" => 5,
	"graph.php" => 7,
	"graph_image.php" => 7,
	"graph_xport.php" => 7,
	"graph_settings.php" => 7,
	"graph_templates.php" => 10,
	"graph_templates_inputs.php" => 10,
	"graph_templates_items.php" => 10,
	"graph_view.php" => 7,
	"graphs.php" => 5,
	"graphs_items.php" => 5,
	"graphs_new.php" => 5,
	"host.php" => 3,
	"host_templates.php" => 12,
	"index.php" => 8,
	"rra.php" => 9,
	"settings.php" => 15,
	"data_queries.php" => 13,
	"templates_export.php" => 16,
	"templates_import.php" => 17,
	"tree.php" => 4,
	"user_admin.php" => 1,
	"utilities.php" => 15,
	"smtp_servers.php" => 8,
	"email_templates.php" => 8,
	"event_queue.php" => 8,
	"smtp_queue.php" => 8,
	"logout.php" => -1
	);

$hash_type_codes = array(
	"round_robin_archive" => "15",
	"cdef" => "05",
	"cdef_item" => "14",
	"gprint_preset" => "06",
	"data_input_method" => "03",
	"data_input_field" => "07",
	"data_template" => "01",
	"data_template_item" => "08",
	"graph_template" => "00",
	"graph_template_item" => "10",
	"graph_template_input" => "09",
	"data_query" => "04",
	"data_query_graph" => "11",
	"data_query_sv_graph" => "12",
	"data_query_sv_data_source" => "13",
	"host_template" => "02"
	);

$hash_version_codes = array(
	"0.8.4"  => "0000",
	"0.8.5"  => "0001",
	"0.8.5a" => "0002",
	"0.8.6"  => "0003",
	"0.8.6a" => "0004",
	"0.8.6b" => "0005",
	"0.8.6c" => "0006",
	"0.8.6d" => "0007",
	"0.8.6e" => "0008",
	"0.8.6f" => "0009",
	"0.8.6g" => "0010",
	"0.8.6h" => "0011",
	"0.8.6i" => "0012",
	"0.8.6j" => "0013",
	"0.8.7"  => "0014",
	"0.8.7a" => "0015",
	"0.8.7b" => "0016",
	"0.8.7c" => "0017",
	"0.8.7d" => "0018",
	"0.8.7e" => "0019",
	"0.8.7f" => "0020",
	"0.8.7g" => "0021",
	"0.8.7h" => "0022",
	"0.8.7i" => "0023",
	"0.8.8"  => "0024"
	);

$hash_type_names = array(
	"cdef" => "CDEF",
	"cdef_item" => "CDEF項目",
	"gprint_preset" => "GPRINTプリセット",
	"data_input_method" => "データ入力メソッド",
	"data_input_field" => "データ入力フィールド",
	"data_template" => "データテンプレート",
	"data_template_item" => "データテンプレート項目",
	"graph_template" => "グラフテンプレート",
	"graph_template_item" => "グラフテンプレート項目",
	"graph_template_input" => "グラフテンプレート入力値",
	"data_query" => "データクエリ",
	"host_template" => "ホストテンプレート",
	"round_robin_archive" => "ラウンドロビンアーカイブ（RRA）"
	);

$host_struc = array(
	"host_template_id",
	"description",
	"hostname",
	"notes",
	"snmp_community",
	"snmp_version",
	"snmp_username",
	"snmp_password",
	"snmp_auth_protocol",
	"snmp_priv_passphrase",
	"snmp_priv_protocol",
	"snmp_context",
	"snmp_port",
	"snmp_timeout",
	"max_oids",
	"device_threads",
	"availability_method",
	"ping_method",
	"ping_port",
	"ping_timeout",
	"ping_retries",
	"disabled",
	"status",
	"status_event_count",
	"status_fail_date",
	"status_rec_date",
	"status_last_error",
	"min_time",
	"max_time",
	"cur_time",
	"avg_time",
	"total_polls",
	"failed_polls",
	"availability"
	);

$graph_timespans = array(
	GT_LAST_HALF_HOUR => "30分前",
	GT_LAST_HOUR => "1時間前",
	GT_LAST_2_HOURS => "2時間前",
	GT_LAST_4_HOURS => "4時間前",
	GT_LAST_6_HOURS =>"6時間前",
	GT_LAST_12_HOURS =>"12時間前",
	GT_LAST_DAY =>"1日前",
	GT_LAST_2_DAYS =>"2日前",
	GT_LAST_3_DAYS =>"3日前",
	GT_LAST_4_DAYS =>"4日前",
	GT_LAST_WEEK =>"1週間前",
	GT_LAST_2_WEEKS =>"2週間前",
	GT_LAST_MONTH =>"1ヶ月前",
	GT_LAST_2_MONTHS =>"2ヶ月前",
	GT_LAST_3_MONTHS =>"3ヶ月前",
	GT_LAST_4_MONTHS =>"4ヶ月前",
	GT_LAST_6_MONTHS =>"6ヶ月前",
	GT_LAST_YEAR =>"1年前",
	GT_LAST_2_YEARS =>"2年前",
	GT_DAY_SHIFT => "日中",
	GT_THIS_DAY => "今日",
	GT_THIS_WEEK => "今週",
	GT_THIS_MONTH => "今月",
	GT_THIS_YEAR => "今年",
	GT_PREV_DAY => "前日",
	GT_PREV_WEEK => "前週",
	GT_PREV_MONTH => "前月",
	GT_PREV_YEAR => "前年"
	);

$graph_timeshifts = array(
	GTS_HALF_HOUR => "30分",
	GTS_1_HOUR => "1時間",
	GTS_2_HOURS => "2時間",
	GTS_4_HOURS => "4時間",
	GTS_6_HOURS => "6時間",
	GTS_12_HOURS => "12時間",
	GTS_1_DAY => "1日間",
	GTS_2_DAYS => "2日間",
	GTS_3_DAYS => "3日間",
	GTS_4_DAYS => "4日間",
	GTS_1_WEEK => "1週間",
	GTS_2_WEEKS => "2週間",
	GTS_1_MONTH => "1ヶ月間",
	GTS_2_MONTHS => "2ヶ月間",
	GTS_3_MONTHS => "3ヶ月間",
	GTS_4_MONTHS => "4ヶ月間",
	GTS_6_MONTHS => "6ヶ月間",
	GTS_1_YEAR => "1年間",
	GTS_2_YEARS => "2年間"
	);

$graph_weekdays = array(
	WD_SUNDAY => "日曜日",
	WD_MONDAY => "月曜日",
	WD_TUESDAY => "火曜日",
	WD_WEDNESDAY => "水曜日",
	WD_THURSDAY => "木曜日",
	WD_FRIDAY => "金曜日",
	WD_SATURDAY => "土曜日"
	);

$graph_dateformats = array(
	GD_MO_D_Y => "月(数字), 日, 年",
	GD_MN_D_Y => "月(文字), 日, 年",
	GD_D_MO_Y => "日, 月(数字), 年",
	GD_D_MN_Y => "日, 月(文字), 年",
	GD_Y_MO_D => "年, 月(数字), 日",
	GD_Y_MN_D => "年, 月(文字), 日"
	);

$graph_datechar = array(
	GDC_HYPHEN => "-",
	GDC_SLASH => "/"
	);

$plugin_architecture = array(
	'version' => '3.1'
	);

api_plugin_hook('config_arrays');

?>
